/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.index;

import java.util.HashSet;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.index.BaseIndex;
import net.lapismc.datastore.drivers.h2.index.Cursor;
import net.lapismc.datastore.drivers.h2.index.IndexType;
import net.lapismc.datastore.drivers.h2.index.RangeCursor;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.result.Row;
import net.lapismc.datastore.drivers.h2.result.SearchRow;
import net.lapismc.datastore.drivers.h2.result.SortOrder;
import net.lapismc.datastore.drivers.h2.table.Column;
import net.lapismc.datastore.drivers.h2.table.IndexColumn;
import net.lapismc.datastore.drivers.h2.table.RangeTable;
import net.lapismc.datastore.drivers.h2.table.TableFilter;

public class RangeIndex
extends BaseIndex {
    private final RangeTable rangeTable;

    public RangeIndex(RangeTable rangeTable, IndexColumn[] indexColumnArray) {
        this.initBaseIndex(rangeTable, 0, "RANGE_INDEX", indexColumnArray, IndexType.createNonUnique(true));
        this.rangeTable = rangeTable;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l;
        long l2;
        long l3 = l2 = this.rangeTable.getMin(session);
        long l4 = l = this.rangeTable.getMax(session);
        long l5 = this.rangeTable.getStep(session);
        try {
            l3 = Math.max(l2, searchRow == null ? l2 : searchRow.getValue(0).getLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            l4 = Math.min(l, searchRow2 == null ? l : searchRow2.getValue(0).getLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RangeCursor(session, l3, l4, l5);
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, HashSet<Column> hashSet) {
        return 1.0;
    }

    @Override
    public String getCreateSQL() {
        return null;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYSTEM_RANGE");
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        long l = bl ? this.rangeTable.getMin(session) : this.rangeTable.getMax(session);
        return new RangeCursor(session, l, l);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rangeTable.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }
}

