/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.expression;

import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Comparison;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.expression.ExpressionVisitor;
import net.lapismc.datastore.drivers.h2.index.IndexCondition;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.table.ColumnResolver;
import net.lapismc.datastore.drivers.h2.table.TableFilter;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueArray;
import net.lapismc.datastore.drivers.h2.value.ValueBoolean;
import net.lapismc.datastore.drivers.h2.value.ValueNull;

public class ValueExpression
extends Expression {
    private static final Object NULL = new ValueExpression(ValueNull.INSTANCE);
    private static final Object DEFAULT = new ValueExpression(ValueNull.INSTANCE);
    private final Value value;

    private ValueExpression(Value value) {
        this.value = value;
    }

    public static ValueExpression getNull() {
        return (ValueExpression)NULL;
    }

    public static ValueExpression getDefault() {
        return (ValueExpression)DEFAULT;
    }

    public static ValueExpression get(Value value) {
        if (value == ValueNull.INSTANCE) {
            return ValueExpression.getNull();
        }
        return new ValueExpression(value);
    }

    @Override
    public Value getValue(Session session) {
        return this.value;
    }

    @Override
    public int getType() {
        return this.value.getType();
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        boolean bl;
        if (this.value.getType() == 1 && !(bl = ((ValueBoolean)this.value).getBoolean())) {
            tableFilter.addIndexCondition(IndexCondition.get(8, null, this));
        }
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.FALSE));
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isValueSet() {
        return true;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public int getScale() {
        return this.value.getScale();
    }

    @Override
    public long getPrecision() {
        return this.value.getPrecision();
    }

    @Override
    public int getDisplaySize() {
        return this.value.getDisplaySize();
    }

    @Override
    public String getSQL() {
        if (this == DEFAULT) {
            return "DEFAULT";
        }
        return this.value.getSQL();
    }

    @Override
    public void updateAggregate(Session session) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        if (this.getType() == 17) {
            return ValueExpression.getExpressionColumns(session, (ValueArray)this.getValue(session));
        }
        return super.getExpressionColumns(session);
    }
}

