/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.expression;

import java.util.AbstractList;
import net.lapismc.datastore.drivers.h2.engine.Database;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Comparison;
import net.lapismc.datastore.drivers.h2.expression.Condition;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.expression.ExpressionColumn;
import net.lapismc.datastore.drivers.h2.expression.ExpressionVisitor;
import net.lapismc.datastore.drivers.h2.expression.Parameter;
import net.lapismc.datastore.drivers.h2.expression.ValueExpression;
import net.lapismc.datastore.drivers.h2.index.IndexCondition;
import net.lapismc.datastore.drivers.h2.table.ColumnResolver;
import net.lapismc.datastore.drivers.h2.table.TableFilter;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueArray;
import net.lapismc.datastore.drivers.h2.value.ValueBoolean;
import net.lapismc.datastore.drivers.h2.value.ValueNull;

public class ConditionInParameter
extends Condition {
    private final Database database;
    private Expression left;
    private final Parameter parameter;

    public ConditionInParameter(Database database, Expression expression, Parameter parameter) {
        this.database = database;
        this.left = expression;
        this.parameter = parameter;
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        boolean bl = false;
        boolean bl2 = false;
        Value value2 = this.parameter.getValue(session);
        if (value2 instanceof ValueArray) {
            for (Value value3 : ((ValueArray)value2).getList()) {
                if (value3 == ValueNull.INSTANCE) {
                    bl2 = true;
                    continue;
                }
                bl = Comparison.compareNotNull(this.database, value, value3 = value3.convertTo(value.getType()), 0);
                if (!bl) {
                    continue;
                }
                break;
            }
        } else if (value2 == ValueNull.INSTANCE) {
            bl2 = true;
        } else {
            value2 = value2.convertTo(value.getType());
            bl = Comparison.compareNotNull(this.database, value, value2, 0);
        }
        if (!bl && bl2) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        if (this.left.isConstant() && this.left == ValueExpression.getNull()) {
            return this.left;
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, new ParameterList(this.parameter)));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public String getSQL() {
        return '(' + this.left.getSQL() + " = ANY(" + this.parameter.getSQL() + "))";
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.parameter.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    private static final class ParameterList
    extends AbstractList<Expression> {
        private final Parameter parameter;

        ParameterList(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Expression get(int n) {
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ValueExpression.get(((ValueArray)value).getList()[n]);
            }
            if (n != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ValueExpression.get(value);
        }

        @Override
        public int size() {
            if (!this.parameter.isValueSet()) {
                return 0;
            }
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ((ValueArray)value).getList().length;
            }
            return 1;
        }
    }
}

