/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.expression;

import net.lapismc.datastore.drivers.h2.engine.Database;
import net.lapismc.datastore.drivers.h2.expression.Aggregate;
import net.lapismc.datastore.drivers.h2.expression.AggregateDataArrayCollecting;
import net.lapismc.datastore.drivers.h2.expression.AggregateDataCount;
import net.lapismc.datastore.drivers.h2.expression.AggregateDataCountAll;
import net.lapismc.datastore.drivers.h2.expression.AggregateDataDefault;
import net.lapismc.datastore.drivers.h2.expression.AggregateDataHistogram;
import net.lapismc.datastore.drivers.h2.expression.AggregateDataMedian;
import net.lapismc.datastore.drivers.h2.expression.AggregateDataSelectivity;
import net.lapismc.datastore.drivers.h2.value.Value;

abstract class AggregateData {
    AggregateData() {
    }

    static AggregateData create(Aggregate.AggregateType aggregateType) {
        if (aggregateType == Aggregate.AggregateType.SELECTIVITY) {
            return new AggregateDataSelectivity();
        }
        if (aggregateType == Aggregate.AggregateType.GROUP_CONCAT) {
            return new AggregateDataArrayCollecting();
        }
        if (aggregateType == Aggregate.AggregateType.ARRAY_AGG) {
            return new AggregateDataArrayCollecting();
        }
        if (aggregateType == Aggregate.AggregateType.COUNT_ALL) {
            return new AggregateDataCountAll();
        }
        if (aggregateType == Aggregate.AggregateType.COUNT) {
            return new AggregateDataCount();
        }
        if (aggregateType == Aggregate.AggregateType.HISTOGRAM) {
            return new AggregateDataHistogram();
        }
        if (aggregateType == Aggregate.AggregateType.MEDIAN) {
            return new AggregateDataMedian();
        }
        return new AggregateDataDefault(aggregateType);
    }

    abstract void add(Database var1, int var2, boolean var3, Value var4);

    abstract Value getValue(Database var1, int var2, boolean var3);
}

