/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.engine;

import java.util.ArrayList;
import net.lapismc.datastore.drivers.h2.command.CommandInterface;
import net.lapismc.datastore.drivers.h2.engine.SessionInterface;
import net.lapismc.datastore.drivers.h2.result.ResultInterface;
import net.lapismc.datastore.drivers.h2.util.New;
import net.lapismc.datastore.drivers.h2.value.Value;

abstract class SessionWithState
implements SessionInterface {
    protected ArrayList<String> sessionState;
    protected boolean sessionStateChanged;
    private boolean sessionStateUpdating;

    SessionWithState() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recreateSessionState() {
        if (this.sessionState != null && !this.sessionState.isEmpty()) {
            this.sessionStateUpdating = true;
            try {
                for (String string : this.sessionState) {
                    CommandInterface commandInterface = this.prepareCommand(string, Integer.MAX_VALUE);
                    commandInterface.executeUpdate(false);
                }
            }
            finally {
                this.sessionStateUpdating = false;
                this.sessionStateChanged = false;
            }
        }
    }

    public void readSessionState() {
        if (!this.sessionStateChanged || this.sessionStateUpdating) {
            return;
        }
        this.sessionStateChanged = false;
        this.sessionState = New.arrayList();
        CommandInterface commandInterface = this.prepareCommand("SELECT * FROM INFORMATION_SCHEMA.SESSION_STATE", Integer.MAX_VALUE);
        ResultInterface resultInterface = commandInterface.executeQuery(0, false);
        while (resultInterface.next()) {
            Value[] valueArray = resultInterface.currentRow();
            this.sessionState.add(valueArray[1].getString());
        }
    }
}

