/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.engine;

import java.lang.ref.WeakReference;
import net.lapismc.datastore.drivers.h2.engine.Database;
import net.lapismc.datastore.drivers.h2.message.Trace;

class DatabaseCloser
extends Thread {
    private final boolean shutdownHook;
    private final Trace trace;
    private volatile WeakReference<Database> databaseRef;
    private int delayInMillis;

    DatabaseCloser(Database database, int n, boolean bl) {
        this.databaseRef = new WeakReference<Database>(database);
        this.delayInMillis = n;
        this.shutdownHook = bl;
        this.trace = database.getTrace(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            this.databaseRef = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.delayInMillis > 0) {
            try {
                int n = 100;
                Thread.sleep(n);
                this.delayInMillis -= n;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.databaseRef != null) continue;
            return;
        }
        Database database = null;
        DatabaseCloser databaseCloser = this;
        synchronized (databaseCloser) {
            if (this.databaseRef != null) {
                database = (Database)this.databaseRef.get();
            }
        }
        if (database != null) {
            try {
                database.close(this.shutdownHook);
            }
            catch (RuntimeException runtimeException) {
                try {
                    this.trace.error(runtimeException, "could not close the database");
                }
                catch (Throwable throwable) {
                    runtimeException.addSuppressed(throwable);
                    throw runtimeException;
                }
            }
        }
    }
}

