/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.constraint;

import java.util.HashSet;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.ExpressionVisitor;
import net.lapismc.datastore.drivers.h2.index.Index;
import net.lapismc.datastore.drivers.h2.result.Row;
import net.lapismc.datastore.drivers.h2.schema.Schema;
import net.lapismc.datastore.drivers.h2.schema.SchemaObjectBase;
import net.lapismc.datastore.drivers.h2.table.Column;
import net.lapismc.datastore.drivers.h2.table.Table;

public abstract class Constraint
extends SchemaObjectBase
implements Comparable<Constraint> {
    protected Table table;

    Constraint(Schema schema, int n, String string, Table table) {
        this.initSchemaObjectBase(schema, n, string, 1);
        this.table = table;
        this.setTemporary(table.isTemporary());
    }

    public abstract Type getConstraintType();

    public abstract void checkRow(Session var1, Table var2, Row var3, Row var4);

    public abstract boolean usesIndex(Index var1);

    public abstract void setIndexOwner(Index var1);

    public abstract HashSet<Column> getReferencedColumns(Table var1);

    public abstract String getCreateSQLWithoutIndexes();

    public abstract boolean isBefore();

    public abstract void checkExistingData(Session var1);

    public abstract void rebuild();

    public abstract Index getUniqueIndex();

    @Override
    public void checkRename() {
    }

    @Override
    public int getType() {
        return 5;
    }

    public Table getTable() {
        return this.table;
    }

    public Table getRefTable() {
        return this.table;
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public int compareTo(Constraint constraint) {
        if (this == constraint) {
            return 0;
        }
        return Integer.compare(this.getConstraintType().ordinal(), constraint.getConstraintType().ordinal());
    }

    @Override
    public boolean isHidden() {
        return this.table.isHidden();
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return true;
    }

    public static enum Type {
        CHECK,
        PRIMARY_KEY,
        UNIQUE,
        REFERENTIAL;


        public String getSqlName() {
            if (this == PRIMARY_KEY) {
                return "PRIMARY KEY";
            }
            if (this == REFERENTIAL) {
                return "FOREIGN KEY";
            }
            return this.name();
        }
    }
}

