/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.command.dml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import net.lapismc.datastore.drivers.h2.command.Prepared;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.expression.ExpressionVisitor;
import net.lapismc.datastore.drivers.h2.expression.Parameter;
import net.lapismc.datastore.drivers.h2.expression.ValueExpression;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.result.ResultInterface;
import net.lapismc.datastore.drivers.h2.result.Row;
import net.lapismc.datastore.drivers.h2.result.RowList;
import net.lapismc.datastore.drivers.h2.table.Column;
import net.lapismc.datastore.drivers.h2.table.PlanItem;
import net.lapismc.datastore.drivers.h2.table.Table;
import net.lapismc.datastore.drivers.h2.table.TableFilter;
import net.lapismc.datastore.drivers.h2.util.New;
import net.lapismc.datastore.drivers.h2.util.StatementBuilder;
import net.lapismc.datastore.drivers.h2.util.StringUtils;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueNull;

public class Update
extends Prepared {
    private Expression condition;
    private TableFilter targetTableFilter;
    private TableFilter sourceTableFilter;
    private Expression limitExpr;
    private final ArrayList<Column> columns = New.arrayList();
    private final HashMap<Column, Expression> expressionMap = new HashMap();

    public Update(Session session) {
        super(session);
    }

    public void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public void setCondition(Expression expression) {
        this.condition = expression;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setAssignment(Column column, Expression expression) {
        if (this.expressionMap.containsKey(column)) {
            throw DbException.get(42121, column.getName());
        }
        this.columns.add(column);
        this.expressionMap.put(column, expression);
        if (expression instanceof Parameter) {
            Parameter parameter = (Parameter)expression;
            parameter.setColumn(column);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update() {
        this.targetTableFilter.startQuery(this.session);
        this.targetTableFilter.reset();
        try (RowList rowList = new RowList(this.session);){
            Row row;
            Object object;
            Table table = this.targetTableFilter.getTable();
            this.session.getUser().checkRight(table, 8);
            table.fire(this.session, 2, true);
            table.lock(this.session, true, false);
            int n = table.getColumns().length;
            this.setCurrentRowNumber(0);
            int n2 = 0;
            Column[] columnArray = table.getColumns();
            int n3 = -1;
            if (this.limitExpr != null && (object = this.limitExpr.getValue(this.session)) != ValueNull.INSTANCE) {
                n3 = ((Value)object).getInt();
            }
            while (this.targetTableFilter.next()) {
                Object object2;
                int n4;
                this.setCurrentRowNumber(n2 + 1);
                if (n3 >= 0 && n2 >= n3) break;
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                object = this.targetTableFilter.get();
                row = table.getTemplateRow();
                boolean bl = false;
                for (n4 = 0; n4 < n; ++n4) {
                    Value value;
                    object2 = this.expressionMap.get(columnArray[n4]);
                    Column column = table.getColumn(n4);
                    if (object2 == null) {
                        if (column.getOnUpdateExpression() != null) {
                            bl = true;
                        }
                        value = object.getValue(n4);
                    } else {
                        value = object2 == ValueExpression.getDefault() ? table.getDefaultValue(this.session, column) : column.convert(((Expression)object2).getValue(this.session));
                    }
                    row.setValue(n4, value);
                }
                if (bl) {
                    bl = false;
                    for (n4 = 0; n4 < n; ++n4) {
                        if (Objects.equals(object.getValue(n4), row.getValue(n4))) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        for (n4 = 0; n4 < n; ++n4) {
                            if (this.expressionMap.get(columnArray[n4]) != null || ((Column)(object2 = table.getColumn(n4))).getOnUpdateExpression() == null) continue;
                            row.setValue(n4, table.getOnUpdateValue(this.session, (Column)object2));
                        }
                    }
                }
                table.validateConvertUpdateSequence(this.session, row);
                n4 = 0;
                if (table.fireRow()) {
                    n4 = table.fireBeforeRow(this.session, (Row)object, row) ? 1 : 0;
                }
                if (n4 == 0) {
                    rowList.add((Row)object);
                    rowList.add(row);
                }
                ++n2;
            }
            table.updateRows(this, this.session, rowList);
            if (table.fireRow()) {
                rowList.invalidateCache();
                rowList.reset();
                while (rowList.hasNext()) {
                    object = rowList.next();
                    row = rowList.next();
                    table.fireAfterRow(this.session, (Row)object, row, false);
                }
            }
            table.fire(this.session, 2, false);
            int n5 = n2;
            return n5;
        }
    }

    @Override
    public String getPlanSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("UPDATE ");
        statementBuilder.append(this.targetTableFilter.getPlanSQL(false)).append("\nSET\n    ");
        for (Column column : this.columns) {
            Expression expression = this.expressionMap.get(column);
            statementBuilder.appendExceptFirst(",\n    ");
            statementBuilder.append(column.getName()).append(" = ").append(expression.getSQL());
        }
        if (this.condition != null) {
            statementBuilder.append("\nWHERE ").append(StringUtils.unEnclose(this.condition.getSQL()));
        }
        if (this.limitExpr != null) {
            statementBuilder.append("\nLIMIT ").append(StringUtils.unEnclose(this.limitExpr.getSQL()));
        }
        return statementBuilder.toString();
    }

    @Override
    public void prepare() {
        if (this.condition != null) {
            this.condition.mapColumns(this.targetTableFilter, 0);
            this.condition = this.condition.optimize(this.session);
            this.condition.createIndexConditions(this.session, this.targetTableFilter);
        }
        for (Column object2 : this.columns) {
            Expression expression = this.expressionMap.get(object2);
            expression.mapColumns(this.targetTableFilter, 0);
            if (this.sourceTableFilter != null) {
                expression.mapColumns(this.sourceTableFilter, 0);
            }
            this.expressionMap.put(object2, expression.optimize(this.session));
        }
        TableFilter[] tableFilterArray = this.sourceTableFilter == null ? new TableFilter[]{this.targetTableFilter} : new TableFilter[]{this.targetTableFilter, this.sourceTableFilter};
        PlanItem planItem = this.targetTableFilter.getBestPlanItem(this.session, tableFilterArray, 0, ExpressionVisitor.allColumnsForTableFilters(tableFilterArray));
        this.targetTableFilter.setPlanItem(planItem);
        this.targetTableFilter.prepare();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 68;
    }

    public void setLimit(Expression expression) {
        this.limitExpr = expression;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    public TableFilter getSourceTableFilter() {
        return this.sourceTableFilter;
    }

    public void setSourceTableFilter(TableFilter tableFilter) {
        this.sourceTableFilter = tableFilter;
    }
}

