/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.command.dml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.lapismc.datastore.drivers.h2.command.Prepared;
import net.lapismc.datastore.drivers.h2.engine.Database;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.mvstore.MVStore;
import net.lapismc.datastore.drivers.h2.mvstore.db.MVTableEngine;
import net.lapismc.datastore.drivers.h2.result.ResultInterface;
import net.lapismc.datastore.drivers.h2.store.FileLister;
import net.lapismc.datastore.drivers.h2.store.PageStore;
import net.lapismc.datastore.drivers.h2.store.fs.FileUtils;
import net.lapismc.datastore.drivers.h2.util.IOUtils;

public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(Session session) {
        super(session);
    }

    public void setFileName(Expression expression) {
        this.fileNameExpr = expression;
    }

    @Override
    public int update() {
        String string = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(string);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String string) {
        Database database = this.session.getDatabase();
        if (!database.isPersistent()) {
            throw DbException.get(90126);
        }
        try {
            MVTableEngine.Store store = database.getMvStore();
            if (store != null) {
                store.flush();
            }
            String string2 = database.getName();
            string2 = FileUtils.getName(string2);
            try (OutputStream outputStream = FileUtils.newOutputStream(string, false);){
                String string3;
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                database.flush();
                if (database.getPageStore() != null) {
                    string3 = database.getName() + ".h2.db";
                    this.backupPageStore(zipOutputStream, string3, database.getPageStore());
                }
                string3 = FileUtils.getParent(database.getName());
                Object object = database.getLobSyncObject();
                synchronized (object) {
                    String string4 = database.getDatabasePath();
                    String string5 = FileUtils.getParent(string4);
                    string5 = FileLister.getDir(string5);
                    ArrayList<String> arrayList = FileLister.getDatabaseFiles(string5, string2, true);
                    for (String string6 : arrayList) {
                        if (string6.endsWith(".lob.db")) {
                            BackupCommand.backupFile(zipOutputStream, string3, string6);
                        }
                        if (!string6.endsWith(".mv.db") || store == null) continue;
                        MVStore mVStore = store.getStore();
                        boolean bl = mVStore.getReuseSpace();
                        mVStore.setReuseSpace(false);
                        try {
                            InputStream inputStream = store.getInputStream();
                            BackupCommand.backupFile(zipOutputStream, string3, string6, inputStream);
                        }
                        finally {
                            mVStore.setReuseSpace(bl);
                        }
                    }
                }
                zipOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupPageStore(ZipOutputStream zipOutputStream, String string, PageStore pageStore) throws IOException {
        Database database = this.session.getDatabase();
        string = FileUtils.getName(string);
        zipOutputStream.putNextEntry(new ZipEntry(string));
        int n = 0;
        try {
            pageStore.setBackup(true);
            while ((n = pageStore.copyDirect(n, zipOutputStream)) >= 0) {
                int n2 = pageStore.getPageCount();
                database.setProgress(3, string, n, n2);
            }
        }
        finally {
            pageStore.setBackup(false);
        }
        zipOutputStream.closeEntry();
    }

    private static void backupFile(ZipOutputStream zipOutputStream, String string, String string2) throws IOException {
        InputStream inputStream = FileUtils.newInputStream(string2);
        BackupCommand.backupFile(zipOutputStream, string, string2, inputStream);
    }

    private static void backupFile(ZipOutputStream zipOutputStream, String string, String string2, InputStream inputStream) throws IOException {
        String string3 = FileUtils.toRealPath(string2);
        if (!string3.startsWith(string = FileUtils.toRealPath(string))) {
            DbException.throwInternalError(string3 + " does not start with " + string);
        }
        string3 = string3.substring(string.length());
        string3 = BackupCommand.correctFileName(string3);
        zipOutputStream.putNextEntry(new ZipEntry(string3));
        IOUtils.copyAndCloseInput(inputStream, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String string) {
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 56;
    }
}

