/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.command;

import java.util.ArrayList;
import java.util.List;
import net.lapismc.datastore.drivers.h2.command.Command;
import net.lapismc.datastore.drivers.h2.engine.Database;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.expression.Parameter;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.message.Trace;
import net.lapismc.datastore.drivers.h2.result.ResultInterface;
import net.lapismc.datastore.drivers.h2.table.TableView;
import net.lapismc.datastore.drivers.h2.util.StatementBuilder;
import net.lapismc.datastore.drivers.h2.value.Value;

public abstract class Prepared {
    protected Session session;
    protected String sqlStatement;
    protected boolean create = true;
    protected ArrayList<Parameter> parameters;
    protected boolean prepareAlways;
    private long modificationMetaId;
    private Command command;
    private int objectId;
    private int currentRowNumber;
    private int rowScanCount;
    private List<TableView> cteCleanups;

    public Prepared(Session session) {
        this.session = session;
        this.modificationMetaId = session.getDatabase().getModificationMetaId();
    }

    public abstract boolean isTransactional();

    public abstract ResultInterface queryMeta();

    public abstract int getType();

    public boolean isReadOnly() {
        return false;
    }

    public boolean needRecompile() {
        Database database = this.session.getDatabase();
        if (database == null) {
            throw DbException.get(90067, "database closed");
        }
        return this.prepareAlways || this.modificationMetaId < database.getModificationMetaId() || database.getSettings().recompileAlways;
    }

    long getModificationMetaId() {
        return this.modificationMetaId;
    }

    void setModificationMetaId(long l) {
        this.modificationMetaId = l;
    }

    public void setParameterList(ArrayList<Parameter> arrayList) {
        this.parameters = arrayList;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    protected void checkParameters() {
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters) {
                parameter.checkSet();
            }
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean isQuery() {
        return false;
    }

    public void prepare() {
    }

    public int update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(int n) {
        throw DbException.get(90002);
    }

    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    public String getSQL() {
        return this.sqlStatement;
    }

    protected int getCurrentObjectId() {
        return this.objectId;
    }

    protected int getObjectId() {
        int n = this.objectId;
        if (n == 0) {
            n = this.session.getDatabase().allocateObjectId();
        } else {
            this.objectId = 0;
        }
        return n;
    }

    public String getPlanSQL() {
        return null;
    }

    public void checkCanceled() {
        Command command;
        this.session.checkCanceled();
        Command command2 = command = this.command != null ? this.command : this.session.getCurrentCommand();
        if (command != null) {
            command.checkCanceled();
        }
    }

    public void setObjectId(int n) {
        this.objectId = n;
        this.create = false;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    void trace(long l, int n) {
        long l2;
        if (this.session.getTrace().isInfoEnabled() && l > 0L) {
            l2 = System.nanoTime() - l;
            String string = Trace.formatParams(this.parameters);
            this.session.getTrace().infoSQL(this.sqlStatement, string, n, l2 / 1000L / 1000L);
        }
        if (this.session.getDatabase().getQueryStatistics() && l != 0L) {
            l2 = System.nanoTime() - l;
            this.session.getDatabase().getQueryStatisticsData().update(this.toString(), l2, n);
        }
    }

    public void setPrepareAlways(boolean bl) {
        this.prepareAlways = bl;
    }

    protected void setCurrentRowNumber(int n) {
        if ((++this.rowScanCount & 0x7F) == 0) {
            this.checkCanceled();
        }
        this.currentRowNumber = n;
        this.setProgress();
    }

    public int getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    private void setProgress() {
        if ((this.currentRowNumber & 0x7F) == 0) {
            this.session.getDatabase().setProgress(7, this.sqlStatement, this.currentRowNumber, 0);
        }
    }

    public String toString() {
        return this.sqlStatement;
    }

    protected static String getSQL(Value[] valueArray) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (Value value : valueArray) {
            statementBuilder.appendExceptFirst(", ");
            if (value == null) continue;
            statementBuilder.append(value.getSQL());
        }
        return statementBuilder.toString();
    }

    protected static String getSQL(Expression[] expressionArray) {
        StatementBuilder statementBuilder = new StatementBuilder();
        for (Expression expression : expressionArray) {
            statementBuilder.appendExceptFirst(", ");
            if (expression == null) continue;
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.toString();
    }

    protected DbException setRow(DbException dbException, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sqlStatement != null) {
            stringBuilder.append(this.sqlStatement);
        }
        stringBuilder.append(" -- ");
        if (n > 0) {
            stringBuilder.append("row #").append(n + 1).append(' ');
        }
        stringBuilder.append('(').append(string).append(')');
        return dbException.addSQL(stringBuilder.toString());
    }

    public boolean isCacheable() {
        return false;
    }

    public List<TableView> getCteCleanups() {
        return this.cteCleanups;
    }

    public void setCteCleanups(List<TableView> list) {
        this.cteCleanups = list;
    }

    public Session getSession() {
        return this.session;
    }
}

