/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore;

import java.io.File;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import net.lapismc.datastore.DataStore;
import net.lapismc.datastore.MySQL;
import net.lapismc.datastore.util.LapisURL;
import net.lapismc.lapiscore.LapisCorePlugin;

public abstract class SQLite
extends MySQL {
    private LapisURL url;

    public SQLite(LapisCorePlugin core, LapisURL url) {
        super(core);
        this.url = url;
        try {
            Class.forName("net.lapismc.datastore.drivers.sqlite.JDBC").newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DataStore.StorageType getStorageType() {
        return DataStore.StorageType.SQLite;
    }

    @Override
    public void initialiseDataStore() {
        File f = this.url.getFile(DataStore.StorageType.SQLite);
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        super.initialiseDataStore();
    }

    @Override
    void getConnection(boolean includeDatabase) {
        try {
            this.conn = DriverManager.getConnection(this.url.getURL(this.getStorageType(), false));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

