/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.lapismc.datastore.drivers.h2.engine.Mode;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.util.DateTimeUtils;
import net.lapismc.datastore.drivers.h2.value.CompareMode;
import net.lapismc.datastore.drivers.h2.value.Value;

public class ValueTimestamp
extends Value {
    public static final int DEFAULT_PRECISION = 26;
    public static final int MAXIMUM_PRECISION = 29;
    static final int DEFAULT_SCALE = 6;
    public static final int MAXIMUM_SCALE = 9;
    private final long dateValue;
    private final long timeNanos;

    public static int getDisplaySize(int n) {
        return n == 0 ? 19 : 20 + n;
    }

    private ValueTimestamp(long l, long l2) {
        this.dateValue = l;
        if (l2 < 0L || l2 >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + l2);
        }
        this.timeNanos = l2;
    }

    public static ValueTimestamp fromDateValueAndNanos(long l, long l2) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(l, l2));
    }

    public static ValueTimestamp get(Timestamp timestamp) {
        long l = timestamp.getTime();
        long l2 = timestamp.getNanos() % 1000000;
        long l3 = DateTimeUtils.dateValueFromDate(l);
        return ValueTimestamp.fromDateValueAndNanos(l3, l2 += DateTimeUtils.nanosFromDate(l));
    }

    public static ValueTimestamp fromMillisNanos(long l, int n) {
        long l2 = DateTimeUtils.dateValueFromDate(l);
        long l3 = (long)n + DateTimeUtils.nanosFromDate(l);
        return ValueTimestamp.fromDateValueAndNanos(l2, l3);
    }

    public static ValueTimestamp fromMillis(long l) {
        long l2 = DateTimeUtils.dateValueFromDate(l);
        long l3 = DateTimeUtils.nanosFromDate(l);
        return ValueTimestamp.fromDateValueAndNanos(l2, l3);
    }

    public static ValueTimestamp parse(String string) {
        return ValueTimestamp.parse(string, null);
    }

    public static ValueTimestamp parse(String string, Mode mode) {
        try {
            return (ValueTimestamp)DateTimeUtils.parseTimestamp(string, mode, false);
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIMESTAMP", string);
        }
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    @Override
    public Timestamp getTimestamp() {
        return DateTimeUtils.convertDateValueToTimestamp(this.dateValue, this.timeNanos);
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(29);
        DateTimeUtils.appendDate(stringBuilder, this.dateValue);
        stringBuilder.append(' ');
        DateTimeUtils.appendTime(stringBuilder, this.timeNanos);
        return stringBuilder.toString();
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 29L;
    }

    @Override
    public int getScale() {
        return 9;
    }

    @Override
    public int getDisplaySize() {
        return 29;
    }

    @Override
    public boolean checkPrecision(long l) {
        return true;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 9) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        long l = this.timeNanos;
        long l2 = DateTimeUtils.convertScale(l, n);
        if (l2 == l) {
            return this;
        }
        long l3 = this.dateValue;
        if (l2 >= 86400000000000L) {
            l2 -= 86400000000000L;
            l3 = DateTimeUtils.incrementDateValue(l3);
        }
        return ValueTimestamp.fromDateValueAndNanos(l3, l2);
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value;
        int n = Long.compare(this.dateValue, valueTimestamp.dateValue);
        if (n != 0) {
            return n;
        }
        return Long.compare(this.timeNanos, valueTimestamp.timeNanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ValueTimestamp)) {
            return false;
        }
        ValueTimestamp valueTimestamp = (ValueTimestamp)object;
        return this.dateValue == valueTimestamp.dateValue && this.timeNanos == valueTimestamp.timeNanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setTimestamp(n, this.getTimestamp());
    }

    @Override
    public Value add(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long l = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long l2 = DateTimeUtils.absoluteDayFromDateValue(valueTimestamp.dateValue);
        return DateTimeUtils.normalizeTimestamp(l + l2, this.timeNanos + valueTimestamp.timeNanos);
    }

    @Override
    public Value subtract(Value value) {
        ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
        long l = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long l2 = DateTimeUtils.absoluteDayFromDateValue(valueTimestamp.dateValue);
        return DateTimeUtils.normalizeTimestamp(l - l2, this.timeNanos - valueTimestamp.timeNanos);
    }
}

