/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.value;

import java.util.Locale;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.value.CompareMode;
import net.lapismc.datastore.drivers.h2.value.DataType;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueEnumBase;
import net.lapismc.datastore.drivers.h2.value.ValueInt;
import net.lapismc.datastore.drivers.h2.value.ValueString;

public class ValueEnum
extends ValueEnumBase {
    private final String[] enumerators;

    private ValueEnum(String[] stringArray, int n) {
        super(stringArray[n], n);
        this.enumerators = stringArray;
    }

    public static void check(String[] stringArray) {
        switch (ValueEnum.validate(stringArray)) {
            case VALID: {
                return;
            }
            case EMPTY: {
                throw DbException.get(22032);
            }
            case DUPLICATE: {
                throw DbException.get(22033, ValueEnum.toString(stringArray));
            }
        }
        throw DbException.get(90008, ValueEnum.toString(stringArray));
    }

    private static void check(String[] stringArray, Value value) {
        ValueEnum.check(stringArray);
        if (ValueEnum.validate(stringArray, value) != Validation.VALID) {
            throw DbException.get(22030, ValueEnum.toString(stringArray), value.toString());
        }
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        return Integer.compare(this.getInt(), value.getInt());
    }

    public static ValueEnum get(String[] stringArray, int n) {
        ValueEnum.check(stringArray, ValueInt.get(n));
        return new ValueEnum(stringArray, n);
    }

    public static ValueEnum get(String[] stringArray, String string) {
        ValueEnum.check(stringArray, ValueString.get(string));
        String string2 = ValueEnum.sanitize(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(ValueEnum.sanitize(stringArray[i]))) continue;
            return new ValueEnum(stringArray, i);
        }
        throw DbException.get(50000, "Unexpected error");
    }

    public String[] getEnumerators() {
        return this.enumerators;
    }

    public static boolean isValid(String[] stringArray, Value value) {
        return ValueEnum.validate(stringArray, value).equals((Object)Validation.VALID);
    }

    private static String sanitize(String string) {
        return string == null ? null : string.trim().toUpperCase(Locale.ENGLISH);
    }

    private static String[] sanitize(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = ValueEnum.sanitize(stringArray[i]);
        }
        return stringArray2;
    }

    private static String toString(String[] stringArray) {
        String string = "(";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + "'" + stringArray[i] + "'";
            if (i >= stringArray.length - 1) continue;
            string = string + ", ";
        }
        string = string + ")";
        return string;
    }

    private static Validation validate(String[] stringArray) {
        String[] stringArray2 = ValueEnum.sanitize(stringArray);
        if (stringArray2 == null || stringArray2.length == 0) {
            return Validation.EMPTY;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i] == null || stringArray2[i].equals("")) {
                return Validation.EMPTY;
            }
            if (i >= stringArray2.length - 1) continue;
            for (int j = i + 1; j < stringArray2.length; ++j) {
                if (!stringArray2[i].equals(stringArray2[j])) continue;
                return Validation.DUPLICATE;
            }
        }
        return Validation.VALID;
    }

    private static Validation validate(String[] stringArray, Value value) {
        Validation validation = ValueEnum.validate(stringArray);
        if (!validation.equals((Object)Validation.VALID)) {
            return validation;
        }
        if (DataType.isStringType(value.getType())) {
            String string = ValueEnum.sanitize(value.getString());
            for (String string2 : stringArray) {
                if (!string.equals(ValueEnum.sanitize(string2))) continue;
                return Validation.VALID;
            }
            return Validation.INVALID;
        }
        int n = value.getInt();
        if (n < 0 || n >= stringArray.length) {
            return Validation.INVALID;
        }
        return Validation.VALID;
    }

    private static enum Validation {
        DUPLICATE,
        EMPTY,
        INVALID,
        VALID;

    }
}

