/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.util.ColumnNamerConfiguration;

public class ColumnNamer {
    private static final String DEFAULT_COLUMN_NAME = "DEFAULT";
    private final ColumnNamerConfiguration configuration;
    private final Session session;
    private final Set<String> existingColumnNames = new HashSet<String>();

    public ColumnNamer(Session session) {
        this.session = session;
        if (this.session != null && this.session.getColumnNamerConfiguration() != null) {
            this.configuration = this.session.getColumnNamerConfiguration();
        } else {
            this.configuration = ColumnNamerConfiguration.getDefault();
            if (session != null) {
                session.setColumnNamerConfiguration(this.configuration);
            }
        }
    }

    public String getColumnName(Expression expression, int n, String[] stringArray) {
        String string = null;
        if (stringArray != null && stringArray.length > n) {
            string = stringArray[n];
        }
        return this.getColumnName(expression, n, string);
    }

    public String getColumnName(Expression expression, int n, String string) {
        String string2 = null;
        if (string != null) {
            string2 = string;
            if (!this.isAllowableColumnName(string2)) {
                string2 = this.fixColumnName(string2);
            }
            if (!this.isAllowableColumnName(string2)) {
                string2 = null;
            }
        }
        if (string2 == null && expression.getAlias() != null && !DEFAULT_COLUMN_NAME.equals(expression.getAlias())) {
            string2 = expression.getAlias();
            if (!this.isAllowableColumnName(string2)) {
                string2 = this.fixColumnName(string2);
            }
            if (!this.isAllowableColumnName(string2)) {
                string2 = null;
            }
        }
        if (string2 == null && expression.getColumnName() != null && !DEFAULT_COLUMN_NAME.equals(expression.getColumnName())) {
            string2 = expression.getColumnName();
            if (!this.isAllowableColumnName(string2)) {
                string2 = this.fixColumnName(string2);
            }
            if (!this.isAllowableColumnName(string2)) {
                string2 = null;
            }
        }
        if (string2 == null && expression.getSQL() != null && !DEFAULT_COLUMN_NAME.equals(expression.getSQL())) {
            string2 = expression.getSQL();
            if (!this.isAllowableColumnName(string2)) {
                string2 = this.fixColumnName(string2);
            }
            if (!this.isAllowableColumnName(string2)) {
                string2 = null;
            }
        }
        if (string2 == null) {
            string2 = this.configuration.getDefaultColumnNamePattern().replace("$$", "" + (n + 1));
        }
        if (this.existingColumnNames.contains(string2) && this.configuration.isGenerateUniqueColumnNames()) {
            string2 = this.generateUniqueName(string2);
        }
        this.existingColumnNames.add(string2);
        return string2;
    }

    private String generateUniqueName(String string) {
        String string2 = string;
        int n = 2;
        while (this.existingColumnNames.contains(string2)) {
            String string3 = "_" + n;
            string2 = string.substring(0, Math.min(string.length(), this.configuration.getMaxIdentiferLength() - string3.length())) + string3;
            ++n;
        }
        return string2;
    }

    private boolean isAllowableColumnName(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() > this.configuration.getMaxIdentiferLength() || string.length() == 0) {
            return false;
        }
        Matcher matcher = this.configuration.getCompiledRegularExpressionMatchAllowed().matcher(string);
        return matcher.matches();
    }

    private String fixColumnName(String string) {
        Matcher matcher = this.configuration.getCompiledRegularExpressionMatchDisallowed().matcher(string);
        string = matcher.replaceAll("");
        if (string.length() > this.configuration.getMaxIdentiferLength()) {
            string = string.substring(0, this.configuration.getMaxIdentiferLength());
        }
        return string;
    }

    public ColumnNamerConfiguration getConfiguration() {
        return this.configuration;
    }
}

