/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.mvstore;

import java.util.Iterator;
import net.lapismc.datastore.drivers.h2.mvstore.CursorPos;
import net.lapismc.datastore.drivers.h2.mvstore.DataUtils;
import net.lapismc.datastore.drivers.h2.mvstore.MVMap;
import net.lapismc.datastore.drivers.h2.mvstore.Page;

public class Cursor<K, V>
implements Iterator<K> {
    private final MVMap<K, ?> map;
    private final K from;
    private CursorPos pos;
    private K current;
    private K last;
    private V currentValue;
    private V lastValue;
    private Page lastPage;
    private final Page root;
    private boolean initialized;

    Cursor(MVMap<K, ?> mVMap, Page page, K k) {
        this.map = mVMap;
        this.root = page;
        this.from = k;
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            this.min(this.root, this.from);
            this.initialized = true;
            this.fetchNext();
        }
        return this.current != null;
    }

    @Override
    public K next() {
        this.hasNext();
        K k = this.current;
        this.last = this.current;
        this.lastValue = this.currentValue;
        this.lastPage = this.pos == null ? null : this.pos.page;
        this.fetchNext();
        return k;
    }

    public K getKey() {
        return this.last;
    }

    public V getValue() {
        return this.lastValue;
    }

    Page getPage() {
        return this.lastPage;
    }

    public void skip(long l) {
        if (!this.hasNext()) {
            return;
        }
        if (l < 10L) {
            while (l-- > 0L) {
                this.fetchNext();
            }
            return;
        }
        long l2 = this.map.getKeyIndex(this.current);
        K k = this.map.getKey(l2 + l);
        this.pos = null;
        this.min(this.root, k);
        this.fetchNext();
    }

    @Override
    public void remove() {
        throw DataUtils.newUnsupportedOperationException("Removing is not supported");
    }

    private void min(Page page, K k) {
        int n;
        while (true) {
            if (page.isLeaf()) {
                int n2 = n = k == null ? 0 : page.binarySearch(k);
                if (n < 0) {
                    n = -n - 1;
                }
                break;
            }
            int n3 = n = k == null ? -1 : page.binarySearch(k);
            n = n < 0 ? -n - 1 : ++n;
            this.pos = new CursorPos(page, n + 1, this.pos);
            page = page.getChildPage(n);
        }
        this.pos = new CursorPos(page, n, this.pos);
    }

    private void fetchNext() {
        while (this.pos != null) {
            if (this.pos.index < this.pos.page.getKeyCount()) {
                int n = this.pos.index++;
                this.current = this.pos.page.getKey(n);
                this.currentValue = this.pos.page.getValue(n);
                return;
            }
            this.pos = this.pos.parent;
            if (this.pos == null) break;
            if (this.pos.index >= this.map.getChildPageCount(this.pos.page)) continue;
            this.min(this.pos.page.getChildPage(this.pos.index++), null);
        }
        this.current = null;
    }
}

