/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import net.lapismc.datastore.drivers.h2.command.CommandInterface;
import net.lapismc.datastore.drivers.h2.engine.SessionInterface;
import net.lapismc.datastore.drivers.h2.expression.ParameterInterface;
import net.lapismc.datastore.drivers.h2.jdbc.JdbcBatchUpdateException;
import net.lapismc.datastore.drivers.h2.jdbc.JdbcConnection;
import net.lapismc.datastore.drivers.h2.jdbc.JdbcParameterMetaData;
import net.lapismc.datastore.drivers.h2.jdbc.JdbcPreparedStatementBackwardsCompat;
import net.lapismc.datastore.drivers.h2.jdbc.JdbcResultSet;
import net.lapismc.datastore.drivers.h2.jdbc.JdbcResultSetMetaData;
import net.lapismc.datastore.drivers.h2.jdbc.JdbcStatement;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.result.ResultInterface;
import net.lapismc.datastore.drivers.h2.result.ResultWithGeneratedKeys;
import net.lapismc.datastore.drivers.h2.util.DateTimeUtils;
import net.lapismc.datastore.drivers.h2.util.IOUtils;
import net.lapismc.datastore.drivers.h2.util.MergedResultSet;
import net.lapismc.datastore.drivers.h2.util.New;
import net.lapismc.datastore.drivers.h2.value.DataType;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueBoolean;
import net.lapismc.datastore.drivers.h2.value.ValueByte;
import net.lapismc.datastore.drivers.h2.value.ValueBytes;
import net.lapismc.datastore.drivers.h2.value.ValueDate;
import net.lapismc.datastore.drivers.h2.value.ValueDecimal;
import net.lapismc.datastore.drivers.h2.value.ValueDouble;
import net.lapismc.datastore.drivers.h2.value.ValueFloat;
import net.lapismc.datastore.drivers.h2.value.ValueInt;
import net.lapismc.datastore.drivers.h2.value.ValueLong;
import net.lapismc.datastore.drivers.h2.value.ValueNull;
import net.lapismc.datastore.drivers.h2.value.ValueShort;
import net.lapismc.datastore.drivers.h2.value.ValueString;
import net.lapismc.datastore.drivers.h2.value.ValueTime;
import net.lapismc.datastore.drivers.h2.value.ValueTimestamp;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement,
JdbcPreparedStatementBackwardsCompat {
    protected CommandInterface command;
    private final String sqlStatement;
    private ArrayList<Value[]> batchParameters;
    private MergedResultSet batchIdentities;
    private HashMap<String, Integer> cachedColumnLabelMap;
    private final Object generatedKeysRequest;

    JdbcPreparedStatement(JdbcConnection jdbcConnection, String string, int n, int n2, int n3, boolean bl, Object object) {
        super(jdbcConnection, n, n2, n3, bl);
        this.generatedKeysRequest = jdbcConnection.scopeGeneratedKeys() ? Boolean.valueOf(false) : object;
        this.setTrace(this.session.getTrace(), 3, n);
        this.sqlStatement = string;
        this.command = jdbcConnection.prepareCommand(string, this.fetchSize);
    }

    void setCachedColumnLabelMap(HashMap<String, Integer> hashMap) {
        this.cachedColumnLabelMap = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            int n = JdbcPreparedStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n, "executeQuery()");
            }
            this.batchIdentities = null;
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface resultInterface;
                this.checkClosed();
                this.closeOldResultSet();
                boolean bl = false;
                boolean bl2 = this.resultSetType != 1003;
                boolean bl3 = this.resultSetConcurrency == 1008;
                try {
                    this.setExecutingStatement(this.command);
                    resultInterface = this.command.executeQuery(this.maxRows, bl2);
                    bl = resultInterface.isLazy();
                }
                finally {
                    if (!bl) {
                        this.setExecutingStatement(null);
                    }
                }
                this.resultSet = new JdbcResultSet(this.conn, this, this.command, resultInterface, n, this.closedByResultSet, bl2, bl3, this.cachedColumnLabelMap);
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        int n;
        this.debugCodeCall("executeUpdate");
        this.checkClosedForWrite();
        this.batchIdentities = null;
        try {
            n = this.executeUpdateInternal();
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long executeLargeUpdate() throws SQLException {
        long l;
        this.debugCodeCall("executeLargeUpdate");
        this.checkClosedForWrite();
        this.batchIdentities = null;
        try {
            l = this.executeUpdateInternal();
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal() throws SQLException {
        this.closeOldResultSet();
        SessionInterface sessionInterface = this.session;
        synchronized (sessionInterface) {
            try {
                this.setExecutingStatement(this.command);
                ResultWithGeneratedKeys resultWithGeneratedKeys = this.command.executeUpdate(this.generatedKeysRequest);
                this.updateCount = resultWithGeneratedKeys.getUpdateCount();
                ResultInterface resultInterface = resultWithGeneratedKeys.getGeneratedKeys();
                if (resultInterface != null) {
                    int n = JdbcPreparedStatement.getNextId(4);
                    this.generatedKeys = new JdbcResultSet(this.conn, this, this.command, resultInterface, n, false, true, false);
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        boolean bl;
        int n = JdbcPreparedStatement.getNextId(4);
        if (this.isDebugEnabled()) {
            this.debugCodeCall("execute");
        }
        this.checkClosedForWrite();
        try {
            boolean bl2;
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                this.closeOldResultSet();
                boolean bl3 = false;
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        bl2 = true;
                        boolean bl4 = this.resultSetType != 1003;
                        boolean bl5 = this.resultSetConcurrency == 1008;
                        ResultInterface resultInterface = this.command.executeQuery(this.maxRows, bl4);
                        bl3 = resultInterface.isLazy();
                        this.resultSet = new JdbcResultSet(this.conn, this, this.command, resultInterface, n, this.closedByResultSet, bl4, bl5, this.cachedColumnLabelMap);
                    } else {
                        bl2 = false;
                        ResultWithGeneratedKeys resultWithGeneratedKeys = this.command.executeUpdate(this.generatedKeysRequest);
                        this.updateCount = resultWithGeneratedKeys.getUpdateCount();
                        ResultInterface resultInterface = resultWithGeneratedKeys.getGeneratedKeys();
                        if (resultInterface != null) {
                            this.generatedKeys = new JdbcResultSet(this.conn, this, this.command, resultInterface, n, false, true, false);
                        }
                    }
                }
                finally {
                    if (!bl3) {
                        this.setExecutingStatement(null);
                    }
                }
            }
            bl = bl2;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throw this.logAndConvert(throwable2);
            }
        }
        this.afterWriting();
        return bl;
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.debugCodeCall("clearParameters");
            this.checkClosed();
            ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
            for (ParameterInterface parameterInterface : arrayList) {
                parameterInterface.setValue(null, this.batchParameters == null);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            this.debugCodeCall("executeQuery", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeLargeUpdate", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        try {
            this.debugCodeCall("execute", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n + ", " + n2 + ");");
            }
            this.setParameter(n, ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setInt(" + n + ", " + n2 + ");");
            }
            this.setParameter(n, ValueInt.get(n2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + n + ", " + JdbcPreparedStatement.quote(string) + ");");
            }
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBigDecimal(" + n + ", " + JdbcPreparedStatement.quoteBigDecimal(bigDecimal) + ");");
            }
            Value value = bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n + ", " + JdbcPreparedStatement.quoteDate(date) + ");");
            }
            Value value = date == null ? ValueNull.INSTANCE : ValueDate.get(date);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n + ", " + JdbcPreparedStatement.quoteTime(time) + ");");
            }
            Value value = time == null ? ValueNull.INSTANCE : ValueTime.get(time);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n + ", " + JdbcPreparedStatement.quoteTimestamp(timestamp) + ");");
            }
            Value value = timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(timestamp);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n + ", x);");
            }
            if (object == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DataType.convertToValue(this.session, object, -1));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n + ", x, " + n2 + ");");
            }
            int n3 = DataType.convertSQLTypeToValueType(n2);
            if (object == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                Value value = DataType.convertToValue(this.conn.getSession(), object, n3);
                this.setParameter(n, value.convertTo(n3));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n + ", x, " + n2 + ", " + n3 + ");");
            }
            this.setObject(n, object, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBoolean(" + n + ", " + bl + ");");
            }
            this.setParameter(n, ValueBoolean.get(bl));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setByte(" + n + ", " + by + ");");
            }
            this.setParameter(n, ValueByte.get(by));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setShort(" + n + ", (short) " + s + ");");
            }
            this.setParameter(n, ValueShort.get(s));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setLong(" + n + ", " + l + "L);");
            }
            this.setParameter(n, ValueLong.get(l));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setFloat(" + n + ", " + f + "f);");
            }
            this.setParameter(n, ValueFloat.get(f));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDouble(" + n + ", " + d + "d);");
            }
            this.setParameter(n, ValueDouble.get(d));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n + ", " + JdbcPreparedStatement.quoteDate(date) + ", calendar);");
            }
            if (date == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DateTimeUtils.convertDate(date, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n + ", " + JdbcPreparedStatement.quoteTime(time) + ", calendar);");
            }
            if (time == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DateTimeUtils.convertTime(time, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n + ", " + JdbcPreparedStatement.quoteTimestamp(timestamp) + ", calendar);");
            }
            if (timestamp == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DateTimeUtils.convertTimestamp(timestamp, calendar));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n + ", " + n2 + ", " + JdbcPreparedStatement.quote(string) + ");");
            }
            this.setNull(n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = reader == null ? ValueNull.INSTANCE : this.conn.createClob(reader, -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setArray(" + n + ", x);");
            }
            this.checkClosed();
            Value value = array == null ? ValueNull.INSTANCE : DataType.convertToValue(this.session, array.getArray(), 17);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + n + ", " + JdbcPreparedStatement.quoteBytes(byArray) + ");");
            }
            Value value = byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, (long)n2);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n, inputStream, -1);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream, (long)n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAsciiStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream), l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.setAsciiStream(n, inputStream, -1);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(n, reader, (long)n2);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setCharacterStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.debugCodeCall("getMetaData");
            this.checkClosed();
            ResultInterface resultInterface = this.command.getMetaData();
            if (resultInterface == null) {
                return null;
            }
            int n = JdbcPreparedStatement.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, n, "getMetaData()");
            }
            String string = this.conn.getCatalog();
            return new JdbcResultSetMetaData(null, this, resultInterface, string, this.session.getTrace(), n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchParameters = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
            this.batchParameters = null;
            if (this.command != null) {
                this.command.close();
                this.command = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        int n = JdbcPreparedStatement.getNextId(3);
        this.debugCodeCall("executeBatch");
        if (this.batchParameters == null) {
            this.batchParameters = New.arrayList();
        }
        this.batchIdentities = new MergedResultSet();
        int n2 = this.batchParameters.size();
        int[] nArray2 = new int[n2];
        boolean bl = false;
        Object object = null;
        this.checkClosedForWrite();
        try {
            for (int i = 0; i < n2; ++i) {
                Object object2;
                Value[] valueArray = this.batchParameters.get(i);
                ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
                for (int j = 0; j < valueArray.length; ++j) {
                    object2 = valueArray[j];
                    ParameterInterface parameterInterface = arrayList.get(j);
                    parameterInterface.setValue((Value)object2, false);
                }
                try {
                    nArray2[i] = this.executeUpdateInternal();
                    ResultSet resultSet = super.getGeneratedKeys();
                    this.batchIdentities.add(resultSet);
                    continue;
                }
                catch (Exception exception) {
                    object2 = this.logAndConvert(exception);
                    if (object == null) {
                        object = object2;
                    } else {
                        ((SQLException)object2).setNextException((SQLException)object);
                        object = object2;
                    }
                    nArray2[i] = -3;
                    bl = true;
                }
            }
            this.batchParameters = null;
            if (bl) {
                throw new JdbcBatchUpdateException((SQLException)object, nArray2);
            }
            nArray = nArray2;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        this.afterWriting();
        return nArray;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.batchIdentities != null) {
            return this.batchIdentities.getResult();
        }
        return super.getGeneratedKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        try {
            this.debugCodeCall("addBatch");
            this.checkClosedForWrite();
            try {
                ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
                int n = arrayList.size();
                Value[] valueArray = new Value[n];
                for (int i = 0; i < n; ++i) {
                    Value value;
                    ParameterInterface parameterInterface = arrayList.get(i);
                    parameterInterface.checkSet();
                    valueArray[i] = value = parameterInterface.getParamValue();
                }
                if (this.batchParameters == null) {
                    this.batchParameters = New.arrayList();
                }
                this.batchParameters.add(valueArray);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + n + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + n + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteIntArray(nArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteIntArray(nArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteArray(stringArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteArray(stringArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcPreparedStatement.quote(string) + ", " + n + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteIntArray(nArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteArray(stringArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            int n = JdbcPreparedStatement.getNextId(11);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ParameterMetaData", 11, n, "getParameterMetaData()");
            }
            this.checkClosed();
            return new JdbcParameterMetaData(this.session.getTrace(), this, this.command, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void setParameter(int n, Value value) {
        this.checkClosed();
        ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
        if (--n < 0 || n >= arrayList.size()) {
            throw DbException.getInvalidValueException("parameterIndex", n + 1);
        }
        ParameterInterface parameterInterface = arrayList.get(n);
        parameterInterface.setValue(value, this.batchParameters == null);
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNString(" + n + ", " + JdbcPreparedStatement.quote(string) + ");");
            }
            Value value = string == null ? ValueNull.INSTANCE : ValueString.get(string);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNCharacterStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setNCharacterStream(n, reader, -1L);
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            Value value = nClob == null ? ValueNull.INSTANCE : this.conn.createClob(nClob.getCharacterStream(), -1L);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, -1L);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createBlob(inputStream, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            try {
                Value value = this.conn.createClob(reader, l);
                this.setParameter(n, value);
            }
            finally {
                this.afterWriting();
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw this.unsupported("SQLXML");
    }

    @Override
    public String toString() {
        return this.getTraceObjectName() + ": " + this.command;
    }

    @Override
    protected boolean checkClosed(boolean bl) {
        if (super.checkClosed(bl)) {
            ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
            this.command = this.conn.prepareCommand(this.sqlStatement, this.fetchSize);
            ArrayList<? extends ParameterInterface> arrayList2 = this.command.getParameters();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ParameterInterface parameterInterface = arrayList.get(i);
                Value value = parameterInterface.getParamValue();
                if (value == null) continue;
                ParameterInterface parameterInterface2 = arrayList2.get(i);
                parameterInterface2.setValue(value, false);
            }
            return true;
        }
        return false;
    }
}

