/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.index;

import java.util.HashSet;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.engine.SysProperties;
import net.lapismc.datastore.drivers.h2.index.Cursor;
import net.lapismc.datastore.drivers.h2.index.IndexType;
import net.lapismc.datastore.drivers.h2.index.PageBtree;
import net.lapismc.datastore.drivers.h2.index.PageBtreeCursor;
import net.lapismc.datastore.drivers.h2.index.PageBtreeLeaf;
import net.lapismc.datastore.drivers.h2.index.PageBtreeNode;
import net.lapismc.datastore.drivers.h2.index.PageIndex;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.result.Row;
import net.lapismc.datastore.drivers.h2.result.SearchRow;
import net.lapismc.datastore.drivers.h2.result.SortOrder;
import net.lapismc.datastore.drivers.h2.store.Data;
import net.lapismc.datastore.drivers.h2.store.Page;
import net.lapismc.datastore.drivers.h2.store.PageStore;
import net.lapismc.datastore.drivers.h2.table.Column;
import net.lapismc.datastore.drivers.h2.table.IndexColumn;
import net.lapismc.datastore.drivers.h2.table.RegularTable;
import net.lapismc.datastore.drivers.h2.table.TableFilter;
import net.lapismc.datastore.drivers.h2.util.MathUtils;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueNull;

public class PageBtreeIndex
extends PageIndex {
    private static int memoryChangeRequired;
    private final PageStore store;
    private final RegularTable tableData;
    private final boolean needRebuild;
    private long rowCount;
    private int memoryPerPage;
    private int memoryCount;

    public PageBtreeIndex(RegularTable regularTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, Session session) {
        this.initBaseIndex(regularTable, n, string, indexColumnArray, indexType);
        if (!this.database.isStarting() && bl) {
            PageBtreeIndex.checkIndexColumnTypes(indexColumnArray);
        }
        this.tableData = regularTable;
        if (!this.database.isPersistent() || n < 0) {
            throw DbException.throwInternalError("" + string);
        }
        this.store = this.database.getPageStore();
        this.store.addIndex(this);
        if (bl) {
            this.rootPageId = this.store.allocatePage();
            this.store.addMeta(this, session);
            PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this, this.rootPageId, 0);
            this.store.logUndo(pageBtreeLeaf, null);
            this.store.update(pageBtreeLeaf);
        } else {
            this.rootPageId = this.store.getRootPageId(n);
            PageBtree pageBtree = this.getPage(this.rootPageId);
            this.rowCount = pageBtree.getRowCount();
        }
        boolean bl2 = this.needRebuild = bl || this.rowCount == 0L && this.store.isRecoveryRunning();
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened {0} rows: {1}", this.getName(), this.rowCount);
        }
        this.memoryPerPage = 184 + this.store.getPageSize() >> 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, Row row) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} add {1}", this.getName(), row);
        }
        SearchRow searchRow = this.getSearchRow(row);
        try {
            this.addRow(searchRow);
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    private void addRow(SearchRow searchRow) {
        PageBtree pageBtree;
        int n;
        while ((n = (pageBtree = this.getPage(this.rootPageId)).addRowTry(searchRow)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split {0}", n);
            }
            SearchRow searchRow2 = pageBtree.getRow(n - 1);
            this.store.logUndo(pageBtree, pageBtree.data);
            PageBtree pageBtree2 = pageBtree;
            PageBtree pageBtree3 = pageBtree.split(n);
            this.store.logUndo(pageBtree3, null);
            int n2 = this.store.allocatePage();
            pageBtree2.setPageId(n2);
            pageBtree2.setParentPageId(this.rootPageId);
            pageBtree3.setParentPageId(this.rootPageId);
            PageBtreeNode pageBtreeNode = PageBtreeNode.create(this, this.rootPageId, 0);
            this.store.logUndo(pageBtreeNode, null);
            pageBtreeNode.init(pageBtree2, searchRow2, pageBtree3);
            this.store.update(pageBtree2);
            this.store.update(pageBtree3);
            this.store.update(pageBtreeNode);
            pageBtree = pageBtreeNode;
        }
        this.invalidateRowCount();
        ++this.rowCount;
    }

    private SearchRow getSearchRow(Row row) {
        SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
        searchRow.setKeyAndVersion(row);
        for (Column column : this.columns) {
            int n = column.getColumnId();
            searchRow.setValue(n, row.getValue(n));
        }
        return searchRow;
    }

    PageBtree getPage(int n) {
        Page page = this.store.getPage(n);
        if (page == null) {
            PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this, n, 0);
            this.store.logUndo(pageBtreeLeaf, null);
            this.store.update(pageBtreeLeaf);
            return pageBtreeLeaf;
        }
        if (!(page instanceof PageBtree)) {
            throw DbException.get(90030, "" + page);
        }
        return (PageBtree)page;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, true, searchRow2);
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, false, searchRow2);
    }

    private Cursor find(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) {
        if (SysProperties.CHECK && this.store == null) {
            throw DbException.get(90007);
        }
        PageBtree pageBtree = this.getPage(this.rootPageId);
        PageBtreeCursor pageBtreeCursor = new PageBtreeCursor(session, this, searchRow2);
        pageBtree.find(pageBtreeCursor, searchRow, bl);
        return pageBtreeCursor;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        SearchRow searchRow;
        if (bl) {
            Cursor cursor = this.find(session, null, false, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.columnIds[0]);
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        PageBtree pageBtree = this.getPage(this.rootPageId);
        PageBtreeCursor pageBtreeCursor = new PageBtreeCursor(session, this, null);
        pageBtree.last(pageBtreeCursor);
        pageBtreeCursor.previous();
        while ((searchRow = pageBtreeCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.columnIds[0]);
            if (value != ValueNull.INSTANCE) {
                return pageBtreeCursor;
            }
            if (pageBtreeCursor.previous()) continue;
        }
        return pageBtreeCursor;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, HashSet<Column> hashSet) {
        return 10L * this.getCostRangeIndex(nArray, this.tableData.getRowCount(session), tableFilterArray, n, sortOrder, false, hashSet);
    }

    @Override
    public boolean needRebuild() {
        return this.needRebuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Session session, Row row) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("{0} remove {1}", this.getName(), row);
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            try {
                PageBtree pageBtree = this.getPage(this.rootPageId);
                pageBtree.remove(row);
                this.invalidateRowCount();
                --this.rowCount;
            }
            finally {
                this.store.incrementChangeCount();
            }
        }
    }

    @Override
    public void remove(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.removeAllRows();
        this.store.free(this.rootPageId);
        this.store.removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject()) {
            this.database.getLobStorage().removeAllForTable(this.table.getId());
        }
        this.tableData.setRowCount(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllRows() {
        try {
            PageBtree pageBtree = this.getPage(this.rootPageId);
            pageBtree.freeRecursive();
            pageBtree = PageBtreeLeaf.create(this, this.rootPageId, 0);
            this.store.removeFromCache(this.rootPageId);
            this.store.update(pageBtree);
            this.rowCount = 0L;
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    @Override
    public void checkRename() {
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.tableData.getRow(session, l);
    }

    PageStore getPageStore() {
        return this.store;
    }

    @Override
    public long getRowCountApproximation() {
        return this.tableData.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.tableData.getDiskSpaceUsed();
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
        try {
            this.writeRowCount();
        }
        finally {
            this.store.incrementChangeCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchRow readRow(Data data, int n, boolean bl, boolean bl2) {
        Data data2 = data;
        synchronized (data2) {
            data.setPos(n);
            long l = data.readVarLong();
            if (bl) {
                if (bl2) {
                    return this.tableData.getRow(null, l);
                }
                SearchRow searchRow = this.table.getTemplateSimpleRow(true);
                searchRow.setKey(l);
                return searchRow;
            }
            SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
            searchRow.setKey(l);
            for (Column column : this.columns) {
                int n2 = column.getColumnId();
                searchRow.setValue(n2, data.readValue());
            }
            return searchRow;
        }
    }

    SearchRow readRow(long l) {
        return this.tableData.getRow(null, l);
    }

    void writeRow(Data data, int n, SearchRow searchRow, boolean bl) {
        data.setPos(n);
        data.writeVarLong(searchRow.getKey());
        if (!bl) {
            for (Column column : this.columns) {
                int n2 = column.getColumnId();
                data.writeValue(searchRow.getValue(n2));
            }
        }
    }

    int getRowSize(Data data, SearchRow searchRow, boolean bl) {
        int n = Data.getVarLongLen(searchRow.getKey());
        if (!bl) {
            for (Column column : this.columns) {
                Value value = searchRow.getValue(column.getColumnId());
                n += data.getValueLen(value);
            }
        }
        return n;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    void setRootPageId(Session session, int n) {
        this.store.removeMeta(this, session);
        this.rootPageId = n;
        this.store.addMeta(this, session);
        this.store.addIndex(this);
    }

    private void invalidateRowCount() {
        PageBtree pageBtree = this.getPage(this.rootPageId);
        pageBtree.setRowCountStored(-1);
    }

    @Override
    public void writeRowCount() {
        if (SysProperties.MODIFY_ON_WRITE && this.rootPageId == 0) {
            return;
        }
        PageBtree pageBtree = this.getPage(this.rootPageId);
        pageBtree.setRowCountStored(MathUtils.convertLongToInt(this.rowCount));
    }

    boolean hasData(SearchRow searchRow) {
        return searchRow.getValue(this.columns[0].getColumnId()) != null;
    }

    int getMemoryPerPage() {
        return this.memoryPerPage;
    }

    void memoryChange(int n) {
        this.memoryPerPage = this.memoryCount < 64 ? (this.memoryPerPage += (n - this.memoryPerPage) / ++this.memoryCount) : (this.memoryPerPage += (n > this.memoryPerPage ? 1 : -1) + (n - this.memoryPerPage) / 64);
    }

    static boolean isMemoryChangeRequired() {
        if (memoryChangeRequired-- <= 0) {
            memoryChangeRequired = 10;
            return true;
        }
        return false;
    }
}

