/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.expression;

import net.lapismc.datastore.drivers.h2.command.Prepared;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.expression.ExpressionVisitor;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.table.ColumnResolver;
import net.lapismc.datastore.drivers.h2.table.TableFilter;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueInt;

public class Rownum
extends Expression {
    private final Prepared prepared;

    public Rownum(Prepared prepared) {
        if (prepared == null) {
            throw DbException.throwInternalError();
        }
        this.prepared = prepared;
    }

    @Override
    public Value getValue(Session session) {
        return ValueInt.get(this.prepared.getCurrentRowNumber());
    }

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
    }

    @Override
    public Expression optimize(Session session) {
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public long getPrecision() {
        return 10L;
    }

    @Override
    public int getDisplaySize() {
        return 11;
    }

    @Override
    public String getSQL() {
        return "ROWNUM()";
    }

    @Override
    public void updateAggregate(Session session) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 8: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }
}

