/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.expression;

import net.lapismc.datastore.drivers.h2.command.dml.Query;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.expression.Condition;
import net.lapismc.datastore.drivers.h2.expression.Expression;
import net.lapismc.datastore.drivers.h2.expression.ExpressionVisitor;
import net.lapismc.datastore.drivers.h2.result.ResultInterface;
import net.lapismc.datastore.drivers.h2.table.ColumnResolver;
import net.lapismc.datastore.drivers.h2.table.TableFilter;
import net.lapismc.datastore.drivers.h2.util.StringUtils;
import net.lapismc.datastore.drivers.h2.value.Value;
import net.lapismc.datastore.drivers.h2.value.ValueBoolean;

public class ConditionExists
extends Condition {
    private final Query query;

    public ConditionExists(Query query) {
        this.query = query;
    }

    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        ResultInterface resultInterface = this.query.query(1);
        session.addTemporaryResult(resultInterface);
        boolean bl = resultInterface.hasNext();
        return ValueBoolean.get(bl);
    }

    @Override
    public Expression optimize(Session session) {
        session.optimizeQueryExpression(this.query);
        return this;
    }

    @Override
    public String getSQL() {
        return "EXISTS(\n" + StringUtils.indent(this.query.getPlanSQL(), 4, false) + ")";
    }

    @Override
    public void updateAggregate(Session session) {
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.query.mapColumns(columnResolver, n + 1);
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.query.setEvaluatable(tableFilter, bl);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.query.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.query.getCostAsExpression();
    }
}

