/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.lapismc.datastore.drivers.h2.command.CommandInterface;
import net.lapismc.datastore.drivers.h2.command.Parser;
import net.lapismc.datastore.drivers.h2.engine.ConnectionInfo;
import net.lapismc.datastore.drivers.h2.engine.Database;
import net.lapismc.datastore.drivers.h2.engine.DbSettings;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.engine.SessionFactory;
import net.lapismc.datastore.drivers.h2.engine.SysProperties;
import net.lapismc.datastore.drivers.h2.engine.User;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.store.FileLock;
import net.lapismc.datastore.drivers.h2.store.FileLockMethod;
import net.lapismc.datastore.drivers.h2.util.MathUtils;
import net.lapismc.datastore.drivers.h2.util.ThreadDeadlockDetector;
import net.lapismc.datastore.drivers.h2.util.Utils;

public class Engine
implements SessionFactory {
    private static final Engine INSTANCE = new Engine();
    private static final Map<String, Database> DATABASES = new HashMap<String, Database>();
    private volatile long wrongPasswordDelay = SysProperties.DELAY_WRONG_PASSWORD_MIN;
    private boolean jmx;

    private Engine() {
        if (SysProperties.THREAD_DEADLOCK_DETECTOR) {
            ThreadDeadlockDetector.init();
        }
    }

    public static Engine getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session openSession(ConnectionInfo connectionInfo, boolean bl, String string) {
        Database database;
        String string2 = connectionInfo.getName();
        connectionInfo.removeProperty("NO_UPGRADE", false);
        boolean bl2 = connectionInfo.getProperty("OPEN_NEW", false);
        boolean bl3 = false;
        User user = null;
        Object object = DATABASES;
        synchronized (object) {
            database = bl2 || connectionInfo.isUnnamedInMemory() ? null : DATABASES.get(string2);
            if (database == null) {
                if (bl && !Database.exists(string2)) {
                    throw DbException.get(90013, string2);
                }
                database = new Database(connectionInfo, string);
                bl3 = true;
                if (database.getAllUsers().isEmpty()) {
                    user = new User(database, database.allocateObjectId(), connectionInfo.getUserName(), false);
                    user.setAdmin(true);
                    user.setUserPasswordHash(connectionInfo.getUserPasswordHash());
                    database.setMasterUser(user);
                }
                if (!connectionInfo.isUnnamedInMemory()) {
                    DATABASES.put(string2, database);
                }
            }
        }
        if (bl3) {
            database.opened();
        }
        if (database.isClosing()) {
            return null;
        }
        if (user == null) {
            if (database.validateFilePasswordHash(string, connectionInfo.getFilePasswordHash()) && (user = database.findUser(connectionInfo.getUserName())) != null && !user.validateUserPasswordHash(connectionInfo.getUserPasswordHash())) {
                user = null;
            }
            if (bl3 && (user == null || !user.isAdmin())) {
                database.setEventListener(null);
            }
        }
        if (user == null) {
            object = DbException.get(28000);
            database.getTrace(2).error((Throwable)object, "wrong user or password; user: \"" + connectionInfo.getUserName() + "\"");
            database.removeSession(null);
            throw object;
        }
        Engine.checkClustering(connectionInfo, database);
        object = database.createSession(user);
        if (object == null) {
            return null;
        }
        if (connectionInfo.getProperty("JMX", false)) {
            try {
                Utils.callStaticMethod("net.lapismc.datastore.drivers.h2.jmx.DatabaseInfo.registerMBean", connectionInfo, database);
            }
            catch (Exception exception) {
                database.removeSession((Session)object);
                throw DbException.get(50100, exception, "JMX");
            }
            this.jmx = true;
        }
        return object;
    }

    @Override
    public Session createSession(ConnectionInfo connectionInfo) {
        return INSTANCE.createSessionAndValidate(connectionInfo);
    }

    private Session createSessionAndValidate(ConnectionInfo connectionInfo) {
        try {
            ConnectionInfo connectionInfo2 = null;
            String string = connectionInfo.getProperty("FILE_LOCK", null);
            FileLockMethod fileLockMethod = FileLock.getFileLockMethod(string);
            if (fileLockMethod == FileLockMethod.SERIALIZED) {
                connectionInfo.setProperty("OPEN_NEW", "TRUE");
                try {
                    connectionInfo2 = connectionInfo.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw DbException.convert(cloneNotSupportedException);
                }
            }
            Session session = this.openSession(connectionInfo);
            this.validateUserAndPassword(true);
            if (connectionInfo2 != null) {
                session.setConnectionInfo(connectionInfo2);
            }
            return session;
        }
        catch (DbException dbException) {
            if (dbException.getErrorCode() == 28000) {
                this.validateUserAndPassword(false);
            }
            throw dbException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Session openSession(ConnectionInfo connectionInfo) {
        Session session;
        boolean bl = connectionInfo.removeProperty("IFEXISTS", false);
        boolean bl2 = connectionInfo.removeProperty("IGNORE_UNKNOWN_SETTINGS", false);
        String string = connectionInfo.removeProperty("CIPHER", null);
        String string2 = connectionInfo.removeProperty("INIT", null);
        int n = 0;
        while ((session = this.openSession(connectionInfo, bl, string)) == null) {
            if (n > 60000) {
                throw DbException.get(90020, "Waited for database closing longer than 1 minute");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        Session session2 = session;
        synchronized (session2) {
            block15: {
                session.setAllowLiterals(true);
                DbSettings dbSettings = DbSettings.getDefaultSettings();
                for (String string3 : connectionInfo.getKeys()) {
                    if (dbSettings.containsKey(string3)) continue;
                    String string4 = connectionInfo.getProperty(string3);
                    try {
                        CommandInterface commandInterface = session.prepareCommand("SET " + Parser.quoteIdentifier(string3) + " " + string4, Integer.MAX_VALUE);
                        commandInterface.executeUpdate(false);
                    }
                    catch (DbException dbException) {
                        if (dbException.getErrorCode() == 90040) {
                            session.getTrace().error(dbException, "admin rights required; user: \"" + connectionInfo.getUserName() + "\"");
                        } else {
                            session.getTrace().error(dbException, "");
                        }
                        if (bl2) continue;
                        session.close();
                        throw dbException;
                    }
                }
                if (string2 != null) {
                    try {
                        CommandInterface commandInterface = session.prepareCommand(string2, Integer.MAX_VALUE);
                        commandInterface.executeUpdate(false);
                    }
                    catch (DbException dbException) {
                        if (bl2) break block15;
                        session.close();
                        throw dbException;
                    }
                }
            }
            session.setAllowLiterals(false);
            session.commit(true);
        }
        return session;
    }

    private static void checkClustering(ConnectionInfo connectionInfo, Database database) {
        String string = connectionInfo.getProperty(13, null);
        if ("''".equals(string)) {
            return;
        }
        String string2 = database.getCluster();
        if (!("''".equals(string2) || "TRUE".equals(string) || Objects.equals(string, string2))) {
            if (string2.equals("''")) {
                throw DbException.get(90093);
            }
            throw DbException.get(90094, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(String string) {
        if (this.jmx) {
            try {
                Utils.callStaticMethod("net.lapismc.datastore.drivers.h2.jmx.DatabaseInfo.unregisterMBean", string);
            }
            catch (Exception exception) {
                throw DbException.get(50100, exception, "JMX");
            }
        }
        Map<String, Database> map = DATABASES;
        synchronized (map) {
            DATABASES.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUserAndPassword(boolean bl) {
        int n = SysProperties.DELAY_WRONG_PASSWORD_MIN;
        if (bl) {
            long l = this.wrongPasswordDelay;
            if (l > (long)n && l > 0L) {
                Engine engine = INSTANCE;
                synchronized (engine) {
                    l = MathUtils.secureRandomInt((int)l);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.wrongPasswordDelay = n;
                }
            }
        } else {
            Engine engine = INSTANCE;
            synchronized (engine) {
                long l = this.wrongPasswordDelay;
                int n2 = SysProperties.DELAY_WRONG_PASSWORD_MAX;
                if (n2 <= 0) {
                    n2 = Integer.MAX_VALUE;
                }
                this.wrongPasswordDelay += this.wrongPasswordDelay;
                if (this.wrongPasswordDelay > (long)n2 || this.wrongPasswordDelay < 0L) {
                    this.wrongPasswordDelay = n2;
                }
                if (n > 0) {
                    l += Math.abs(MathUtils.secureRandomLong() % 100L);
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw DbException.get(28000);
            }
        }
    }
}

