/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore.drivers.h2.command.ddl;

import java.util.concurrent.CopyOnWriteArrayList;
import net.lapismc.datastore.drivers.h2.command.ddl.SchemaCommand;
import net.lapismc.datastore.drivers.h2.constraint.Constraint;
import net.lapismc.datastore.drivers.h2.constraint.ConstraintActionType;
import net.lapismc.datastore.drivers.h2.engine.Database;
import net.lapismc.datastore.drivers.h2.engine.DbObjectBase;
import net.lapismc.datastore.drivers.h2.engine.Session;
import net.lapismc.datastore.drivers.h2.message.DbException;
import net.lapismc.datastore.drivers.h2.schema.Schema;
import net.lapismc.datastore.drivers.h2.table.Table;
import net.lapismc.datastore.drivers.h2.table.TableView;
import net.lapismc.datastore.drivers.h2.util.StatementBuilder;

public class DropTable
extends SchemaCommand {
    private boolean ifExists;
    private String tableName;
    private Table table;
    private DropTable next;
    private ConstraintActionType dropAction;

    public DropTable(Session session, Schema schema) {
        super(session, schema);
        this.dropAction = session.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void addNextDropTable(DropTable dropTable) {
        if (this.next == null) {
            this.next = dropTable;
        } else {
            this.next.addNextDropTable(dropTable);
        }
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
        if (this.next != null) {
            this.next.setIfExists(bl);
        }
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    private void prepareDrop() {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table == null) {
            if (!this.ifExists) {
                throw DbException.get(42102, this.tableName);
            }
        } else {
            this.session.getUser().checkRight(this.table, 15);
            if (!this.table.canDrop()) {
                throw DbException.get(90118, this.tableName);
            }
            if (this.dropAction == ConstraintActionType.RESTRICT) {
                Object object;
                Object object2;
                StatementBuilder statementBuilder = new StatementBuilder();
                CopyOnWriteArrayList<TableView> copyOnWriteArrayList = this.table.getDependentViews();
                if (copyOnWriteArrayList != null && !copyOnWriteArrayList.isEmpty()) {
                    object2 = copyOnWriteArrayList.iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        statementBuilder.appendExceptFirst(", ");
                        statementBuilder.append(((DbObjectBase)object).getName());
                    }
                }
                if (this.session.getDatabase().getSettings().standardDropTableRestrict && (object2 = this.table.getConstraints()) != null && !object2.isEmpty()) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        Constraint constraint = (Constraint)object.next();
                        if (constraint.getTable() == this.table) continue;
                        statementBuilder.appendExceptFirst(", ");
                        statementBuilder.append(constraint.getName());
                    }
                }
                if (statementBuilder.length() > 0) {
                    throw DbException.get(90107, this.tableName, statementBuilder.toString());
                }
            }
            this.table.lock(this.session, true, true);
        }
        if (this.next != null) {
            this.next.prepareDrop();
        }
    }

    private void executeDrop() {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table != null) {
            this.table.setModified();
            Database database = this.session.getDatabase();
            database.lockMeta(this.session);
            database.removeSchemaObject(this.session, this.table);
        }
        if (this.next != null) {
            this.next.executeDrop();
        }
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.prepareDrop();
        this.executeDrop();
        return 0;
    }

    public void setDropAction(ConstraintActionType constraintActionType) {
        this.dropAction = constraintActionType;
        if (this.next != null) {
            this.next.setDropAction(constraintActionType);
        }
    }

    @Override
    public int getType() {
        return 44;
    }
}

