/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.datastore;

import java.util.List;
import net.lapismc.datastore.Table;
import net.lapismc.lapiscore.LapisCorePlugin;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public abstract class DataStore {
    public String valueSeparator = "\u00ba";
    LapisCorePlugin core;

    DataStore(LapisCorePlugin core) {
        this.core = core;
    }

    public abstract void initialiseDataStore();

    public abstract StorageType getStorageType();

    public abstract void closeConnection();

    public abstract void shutdown();

    public abstract void addData(Table var1, String var2);

    public abstract void addData(Table var1, String var2, String var3, String var4);

    public abstract void setData(Table var1, String var2, String var3, String var4, String var5);

    public abstract Long getLong(Table var1, String var2, String var3, String var4);

    public abstract String getString(Table var1, String var2, String var3, String var4);

    public abstract Boolean getBoolean(Table var1, String var2, String var3, String var4);

    public abstract Object getObject(Table var1, String var2, String var3, String var4);

    public abstract List<Long> getLongList(Table var1, String var2, String var3, String var4);

    public abstract List<String> getStringList(Table var1, String var2, String var3, String var4);

    public abstract List<String> getEntireColumn(Table var1, String var2);

    public abstract List<String> getEntireTable(Table var1);

    public abstract void removeData(Table var1, String var2, String var3);

    protected abstract void dropTable(Table var1);

    public void convertData(DataStore to, List<Table> tables) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.core, () -> {
            for (Table t : tables) {
                List<String> allRows = this.getEntireTable(t);
                for (String values : allRows) {
                    to.addData(t, values);
                }
                this.dropTable(t);
            }
        });
    }

    public static enum StorageType {
        MySQL,
        H2,
        SQLite;

    }
}

