/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore.utils;

import java.io.IOException;
import java.net.URL;
import java.util.Scanner;
import net.lapismc.lapiscore.LapisCorePlugin;

public class SpigotUpdateChecker {
    private LapisCorePlugin plugin;
    private String resourceID;

    public SpigotUpdateChecker(LapisCorePlugin plugin, String resourceID) {
        this.plugin = plugin;
        this.resourceID = resourceID;
    }

    public boolean isUpdateAvailable() {
        String newestVersion = this.getNewestVersionString();
        if (newestVersion == null || newestVersion.equals("")) {
            return false;
        }
        return !newestVersion.equals(this.plugin.getDescription().getVersion());
    }

    public String getNewVersion() {
        return this.getNewestVersionString();
    }

    private String getNewestVersionString() {
        return this.getFromURL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceID);
    }

    private String getFromURL(String stringUrl) {
        String response = "";
        try {
            URL url = new URL(stringUrl);
            Scanner s = new Scanner(url.openStream());
            if (s.hasNext()) {
                response = s.next();
                s.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response;
    }
}

