/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.logging.Logger;
import net.lapismc.lapiscore.utils.FileDownloader;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LapisUpdater {
    private String ID;
    private String jarName;
    private String username;
    private String repoName;
    private String branch;
    private JavaPlugin plugin;
    private Logger logger;
    private Boolean force;
    private String newVersionRawString;

    public LapisUpdater(JavaPlugin plugin, String jarName, String username, String repoName, String branch) {
        this.plugin = plugin;
        this.ID = plugin.getName();
        this.jarName = jarName;
        this.username = username;
        this.repoName = repoName;
        this.branch = branch;
        this.logger = Bukkit.getLogger();
    }

    public boolean checkUpdate() {
        this.force = false;
        return this.updateCheck();
    }

    public void downloadUpdate() {
        this.force = true;
        this.downloadUpdateJar();
    }

    private void downloadUpdateJar() {
        if (this.updateCheck()) {
            try {
                URL changeLogURL = new URL("https://raw.githubusercontent.com/" + this.username + "/" + this.repoName + "/" + this.branch + "/updater/changelog.yml");
                File changeLogFile = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "changelog.yml");
                URL jarURL = new URL("https://raw.githubusercontent.com/" + this.username + "/" + this.repoName + "/" + this.branch + "/updater/" + this.ID + "/" + this.jarName + ".jar");
                File update = this.plugin.getServer().getUpdateFolderFile();
                if (!update.exists() && !update.mkdir()) {
                    this.logger.severe("Failed to generate " + update.getName());
                }
                File jar = new File(update.getAbsolutePath() + File.separator + this.jarName + ".jar");
                new FileDownloader().downloadFile(changeLogURL, changeLogFile).downloadFile(jarURL, jar);
                YamlConfiguration changeLog = YamlConfiguration.loadConfiguration((File)changeLogFile);
                this.logger.info("Changes in newest Version \n" + changeLog.getStringList(this.newVersionRawString).toString().replace("[", "").replace("]", ""));
            }
            catch (IOException e) {
                this.logger.severe("HomeSpawn updater failed to download updates!");
                this.logger.severe("Please check your internet connection and firewall settings and try again later");
            }
        }
    }

    private boolean updateCheck() {
        Integer newVersion;
        Integer oldVersion;
        File updateFile;
        try {
            URL remoteUpdate = new URL("https://raw.githubusercontent.com/" + this.username + "/" + this.repoName + "/" + this.branch + "/updater/update.yml");
            updateFile = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "update.yml");
            Date d = new Date(updateFile.lastModified());
            Date d0 = new Date();
            d0.setTime(d0.getTime() - 3600L);
            if (!updateFile.exists() || this.force.booleanValue() || d.before(d0)) {
                new FileDownloader().downloadFile(remoteUpdate, updateFile);
                if (!updateFile.setLastModified(d0.getTime())) {
                    this.logger.info("Failed to set modified time for " + updateFile.getName());
                }
            }
        }
        catch (IOException e) {
            this.logger.severe("Failed to check for updates!");
            this.logger.severe("Please check your internet and firewall settings and try again later!");
            return false;
        }
        try {
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)updateFile);
            if (!yaml.contains(this.ID)) {
                return false;
            }
            String oldVersionString = this.plugin.getDescription().getVersion().replace(".", "");
            this.newVersionRawString = yaml.getString(this.ID);
            String newVersionString = yaml.getString(this.ID).replace(".", "");
            oldVersion = Integer.parseInt(oldVersionString);
            newVersion = Integer.parseInt(newVersionString);
        }
        catch (Exception e) {
            this.logger.severe("Failed to load update.yml or parse the values! It may be corrupt!");
            this.logger.severe("Please try again later");
            if (!updateFile.delete()) {
                this.logger.info("Failed to delete " + updateFile.getName());
            }
            return false;
        }
        return !oldVersion.equals(newVersion);
    }
}

