/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import net.lapismc.lapiscore.LapisCorePlugin;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class LapisCoreFileWatcher {
    private LapisCorePlugin core;
    private BukkitTask task;
    private boolean stop;

    public LapisCoreFileWatcher(LapisCorePlugin core) {
        this.core = core;
        this.start();
    }

    private void start() {
        this.task = Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.core, () -> {
            try {
                this.watcher();
            }
            catch (IOException | InterruptedException e) {
                this.core.getLogger().warning(this.core.getName() + " file watcher has stopped, configs wont be reloaded until the server restarts");
            }
        });
    }

    public void stop() {
        this.stop = true;
        this.task.cancel();
    }

    private void watcher() throws IOException, InterruptedException {
        WatchService watcher = FileSystems.getDefault().newWatchService();
        Path dir = Paths.get(this.core.getDataFolder().getAbsolutePath(), new String[0]);
        dir.register(watcher, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.core.getLogger().info(this.core.getName() + " file watcher started!");
        WatchKey key = watcher.take();
        while (key != null && !this.stop) {
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                WatchEvent<?> ev = event;
                Path fileName = (Path)ev.context();
                File f = fileName.toFile();
                if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
                    String name;
                    if (!f.getName().endsWith(".yml")) continue;
                    switch (name = f.getName().replace(".yml", "")) {
                        case "config": {
                            this.core.saveDefaultConfig();
                            this.core.reloadConfig();
                            break;
                        }
                        case "messages": {
                            this.core.config.generateConfigs();
                        }
                    }
                    continue;
                }
                if (kind != StandardWatchEventKinds.ENTRY_MODIFY || !f.getName().endsWith(".yml")) continue;
                this.checkConfig(f);
            }
            key.reset();
            if (this.stop) continue;
            key = watcher.take();
        }
        if (!this.stop) {
            throw new IOException("File watcher failed");
        }
    }

    private void checkConfig(File f) {
        String name;
        switch (name = f.getName().replace(".yml", "")) {
            case "config": {
                this.core.reloadConfig();
                if (this.core.perms != null) {
                    this.core.perms.loadPermissions();
                }
                this.core.getLogger().info("Changes made to the " + this.core.getName() + " config have been loaded");
                break;
            }
            case "messages": {
                this.core.config.reloadMessages();
                this.core.getLogger().info("Changes made to " + this.core.getName() + " messages.yml have been loaded");
                break;
            }
            default: {
                this.checkOtherFile(f);
            }
        }
        this.fileUpdate(f);
    }

    public void fileUpdate(File f) {
    }

    public void checkOtherFile(File f) {
    }
}

