/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore.utils;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import net.lapismc.lapiscore.LapisCorePlugin;

public class LapisCoreClassLoader {
    private static final Method ADD_URL_METHOD;
    private LapisCorePlugin core;

    public LapisCoreClassLoader(LapisCorePlugin core) {
        this.core = core;
    }

    public void loadClasses(File file) {
        if (!file.getName().endsWith(".jar")) {
            throw new IllegalArgumentException("The file to class load must be a .jar file");
        }
        ClassLoader classLoader = this.core.getPluginClassLoader();
        if (classLoader instanceof URLClassLoader) {
            try {
                ADD_URL_METHOD.invoke((Object)classLoader, file.toURI().toURL());
            }
            catch (IllegalAccessException | InvocationTargetException | MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        Method addUrlMethod;
        try {
            addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrlMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        ADD_URL_METHOD = addUrlMethod;
    }
}

