/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.lapismc.lapiscore.LapisCorePlugin;
import org.bukkit.ChatColor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class LapisCoreConfiguration {
    private int configVersion;
    private int messagesVersion;
    private LapisCorePlugin core;
    private File messagesFile;
    private YamlConfiguration messages;

    public LapisCoreConfiguration(LapisCorePlugin core, int configVersion, int messagesVersion) {
        this.core = core;
        this.configVersion = configVersion;
        this.messagesVersion = messagesVersion;
        this.messagesFile = new File(core.getDataFolder() + File.separator + "messages.yml");
        this.generateConfigs();
        this.checkConfigVersions();
    }

    public void generateConfigs() {
        this.core.saveDefaultConfig();
        if (!this.messagesFile.exists()) {
            try (InputStream is = this.core.getResource("messages.yml");
                 FileOutputStream os = new FileOutputStream(this.messagesFile);){
                int readBytes;
                byte[] buffer = new byte[4096];
                while ((readBytes = is.read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, readBytes);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.reloadMessages();
    }

    public void reloadMessages() {
        try {
            if (this.messages == null) {
                this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            } else {
                this.messages.load(this.messagesFile);
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.core.primaryColor = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("PrimaryColor", ChatColor.GOLD.toString()));
        this.core.secondaryColor = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getString("SecondaryColor", ChatColor.RED.toString()));
    }

    private void checkConfigVersions() {
        if (this.core.getConfig().getInt("ConfigVersion") != this.configVersion) {
            File oldConfig = new File(this.core.getDataFolder() + File.separator + "config_PRE_" + this.core.getDescription().getVersion() + ".yml");
            File config = new File(this.core.getDataFolder() + File.separator + "config.yml");
            if (oldConfig.exists()) {
                oldConfig.delete();
            }
            config.renameTo(oldConfig);
            if (config.exists()) {
                config.delete();
            }
            this.core.saveDefaultConfig();
            this.core.getLogger().info("The config.yml file has been updated, it is now called config_PRE_" + this.core.getDescription().getVersion() + ".yml, please transfer any values into the new config.yml");
        }
        if (this.messages.getInt("ConfigVersion") != this.messagesVersion) {
            File oldMessages = new File(this.core.getDataFolder() + File.separator + "messages_PRE_" + this.core.getDescription().getVersion() + ".yml");
            if (oldMessages.exists()) {
                oldMessages.delete();
            }
            this.messagesFile.renameTo(oldMessages);
            if (this.messagesFile.exists()) {
                this.messagesFile.delete();
            }
            this.generateConfigs();
            this.core.getLogger().info("The messages.yml file has been updated, it is now called messages_PRE_" + this.core.getDescription().getVersion() + ".yml, please transfer any values into the new messages.yml");
        }
    }

    public YamlConfiguration getMessages() {
        return this.messages;
    }

    private String getRawMessage(String key) {
        if (!this.messages.contains(key)) {
            this.reloadMessages();
        }
        return this.messages.getString(key, "&sError retrieving message from config");
    }

    public String getMessage(String key) {
        return this.colorMessage(this.getRawMessage(key));
    }

    public String colorMessage(String msg) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg.replace("&p", this.core.primaryColor).replace("&s", this.core.secondaryColor));
    }
}

