/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Date;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LapisUpdater {
    private String ID;
    private String jarName;
    private String username;
    private String repoName;
    private String branch;
    private JavaPlugin plugin;
    private Logger logger;
    private Boolean force;
    private String newVersionRawString;

    public LapisUpdater(JavaPlugin plugin, String jarName, String username, String repoName, String branch) {
        this.plugin = plugin;
        this.ID = plugin.getName();
        this.jarName = jarName;
        this.username = username;
        this.repoName = repoName;
        this.branch = branch;
        this.logger = Bukkit.getLogger();
    }

    public boolean checkUpdate() {
        this.force = false;
        return this.updateCheck();
    }

    public void downloadUpdate() {
        this.force = true;
        this.downloadUpdateJar();
    }

    private void downloadUpdateJar() {
        if (this.updateCheck()) {
            try {
                File jar;
                URL changeLogURL = new URL("https://raw.githubusercontent.com/" + this.username + "/" + this.repoName + "/" + this.branch + "/updater/changelog.yml");
                ReadableByteChannel changelogByteChannel = Channels.newChannel(changeLogURL.openStream());
                File changeLogFile = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "changelog.yml");
                URL jarURL = new URL("https://raw.githubusercontent.com/" + this.username + "/" + this.repoName + "/" + this.branch + "/updater/" + this.ID + "/" + this.jarName + ".jar");
                ReadableByteChannel jarByteChannel = Channels.newChannel(jarURL.openStream());
                File update = this.plugin.getServer().getUpdateFolderFile();
                if (!update.exists() && !update.mkdir()) {
                    this.logger.severe("Failed to generate " + update.getName());
                }
                if (!(jar = new File(update.getAbsolutePath() + File.separator + this.jarName + ".jar")).exists() && !jar.createNewFile()) {
                    this.logger.severe("Failed to generate " + jar.getName());
                }
                FileOutputStream jarOutputStream = new FileOutputStream(jar);
                jarOutputStream.getChannel().transferFrom(jarByteChannel, 0L, Long.MAX_VALUE);
                jarByteChannel.close();
                jarOutputStream.flush();
                jarOutputStream.close();
                FileOutputStream changeLogOutputStream = new FileOutputStream(changeLogFile);
                changeLogOutputStream.getChannel().transferFrom(changelogByteChannel, 0L, Long.MAX_VALUE);
                changelogByteChannel.close();
                changeLogOutputStream.flush();
                changeLogOutputStream.close();
                YamlConfiguration changeLog = YamlConfiguration.loadConfiguration((File)changeLogFile);
                this.logger.info("Changes in newest Version \n" + changeLog.getStringList(this.newVersionRawString).toString().replace("[", "").replace("]", ""));
            }
            catch (IOException e) {
                this.logger.severe("HomeSpawn updater failed to download updates!");
                this.logger.severe("Please check your internet connection and firewall settings and try again later");
            }
        }
    }

    private boolean updateCheck() {
        Integer newVersion;
        Integer oldVersion;
        File f;
        try {
            URL website = new URL("https://raw.githubusercontent.com/" + this.username + "/" + this.repoName + "/" + this.branch + "/updater/update.yml");
            ReadableByteChannel rbc = Channels.newChannel(website.openStream());
            f = new File(this.plugin.getDataFolder().getAbsolutePath() + File.separator + "update.yml");
            Date d = new Date(f.lastModified());
            Date d0 = new Date();
            d0.setTime(d0.getTime() - 3600L);
            if (!f.exists() || this.force.booleanValue() || d.before(d0)) {
                FileOutputStream fos = new FileOutputStream(f);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                rbc.close();
                fos.flush();
                fos.close();
                if (!f.setLastModified(d0.getTime())) {
                    this.logger.info("Failed to set modified time for " + f.getName());
                }
            }
        }
        catch (IOException e) {
            this.logger.severe("Failed to check for updates!");
            this.logger.severe("Please check your internet and firewall settings and try again later!");
            return false;
        }
        try {
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((File)f);
            if (!yaml.contains(this.ID)) {
                return false;
            }
            String oldVersionString = this.plugin.getDescription().getVersion().replace(".", "");
            this.newVersionRawString = yaml.getString(this.ID);
            String newVersionString = yaml.getString(this.ID).replace(".", "");
            oldVersion = Integer.parseInt(oldVersionString);
            newVersion = Integer.parseInt(newVersionString);
        }
        catch (Exception e) {
            this.logger.severe("Failed to load update.yml or parse the values! It may be corrupt!");
            this.logger.severe("Please try again later");
            if (!f.delete()) {
                this.logger.info("Failed to delete " + f.getName());
            }
            return false;
        }
        return !oldVersion.equals(newVersion);
    }
}

