/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.lapismc.lapiscore.LapisCorePlugin;
import net.lapismc.lapiscore.permissions.LapisPermission;
import net.lapismc.lapiscore.permissions.PlayerPermission;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;

public class LapisCorePermissions {
    private LapisCorePlugin core;
    private PermissionManager permissionManager;
    private ArrayList<PlayerPermission> permissions = new ArrayList();
    private Cache<UUID, PlayerPermission> assignedPermissionCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public LapisCorePermissions(LapisCorePlugin core) {
        this.core = core;
        this.permissionManager = new PermissionManager();
        this.registerPermissions(new Priority(), new Default());
    }

    public void registerPermissions(LapisPermission ... permission) {
        for (LapisPermission p : permission) {
            this.permissionManager.addPermission(p);
        }
    }

    public void loadPermissions() {
        this.permissions.clear();
        ConfigurationSection permsSection = this.core.getConfig().getConfigurationSection("Permissions");
        Set perms = permsSection.getKeys(false);
        for (String configPermission : perms) {
            String permName = configPermission.replace(",", ".");
            HashMap<LapisPermission, Integer> permMap = new HashMap<LapisPermission, Integer>();
            for (LapisPermission value : this.permissionManager.getPermissions()) {
                String path = "Permissions." + configPermission + "." + value.getName();
                permMap.put(value, this.core.getConfig().getInt(path, 0));
            }
            if (Bukkit.getPluginManager().getPermission(permName) == null) {
                PermissionDefault permissionDefault;
                switch ((Integer)permMap.get(this.permissionManager.getPermission("Default"))) {
                    case 1: {
                        permissionDefault = PermissionDefault.TRUE;
                        break;
                    }
                    case 2: {
                        permissionDefault = PermissionDefault.OP;
                        break;
                    }
                    default: {
                        permissionDefault = PermissionDefault.FALSE;
                    }
                }
                Bukkit.getPluginManager().addPermission(new Permission(permName, permissionDefault));
            }
            Permission bukkitPermission = Bukkit.getPluginManager().getPermission(permName);
            PlayerPermission permission = new PlayerPermission(bukkitPermission, permMap);
            this.permissions.add(permission);
        }
    }

    public Permission getAssignedPermission(UUID uuid) {
        if (this.calculatePermission(uuid) != null) {
            return this.calculatePermission(uuid).getPermission();
        }
        return null;
    }

    public Integer getPermissionValue(UUID uuid, LapisPermission permission) {
        PlayerPermission playerPerm = this.calculatePermission(uuid);
        if (playerPerm == null) {
            return 0;
        }
        return playerPerm.getPermissionValue(permission);
    }

    public boolean isPermitted(UUID uuid, LapisPermission permission) {
        Integer value = this.getPermissionValue(uuid, permission);
        return this.getPermissionValue(uuid, permission) > 0;
    }

    public PlayerPermission calculatePermission(UUID uuid) {
        PlayerPermission cachedValue = (PlayerPermission)this.assignedPermissionCache.getIfPresent((Object)uuid);
        if (cachedValue != null) {
            return cachedValue;
        }
        if (Bukkit.getOfflinePlayer((UUID)uuid).isOnline()) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            ArrayList<PlayerPermission> candidatePermissions = new ArrayList<PlayerPermission>();
            for (PlayerPermission toTest : this.permissions) {
                if (!p.hasPermission(toTest.getPermission())) continue;
                candidatePermissions.add(toTest);
            }
            PlayerPermission assignedPermission = null;
            LapisPermission priority = this.permissionManager.getPermission("Priority");
            for (PlayerPermission candidatePerm : candidatePermissions) {
                if (assignedPermission != null && assignedPermission.getPermissionValue(priority) >= candidatePerm.getPermissionValue(priority)) continue;
                assignedPermission = candidatePerm;
            }
            if (assignedPermission != null) {
                this.savePlayersPermission(uuid, assignedPermission.getPermission());
                this.assignedPermissionCache.put((Object)uuid, (Object)assignedPermission);
            }
            return assignedPermission;
        }
        PlayerPermission assignedPermission = this.convertPermission(this.getOfflinePlayerPermission(uuid));
        if (assignedPermission != null) {
            this.assignedPermissionCache.put((Object)uuid, (Object)assignedPermission);
        }
        return assignedPermission;
    }

    private PlayerPermission convertPermission(Permission perm) {
        for (PlayerPermission candidate : this.permissions) {
            if (candidate.getPermission() != perm) continue;
            return candidate;
        }
        return null;
    }

    protected Permission getOfflinePlayerPermission(UUID uuid) {
        return null;
    }

    protected void savePlayersPermission(UUID uuid, Permission perm) {
    }

    private class Default
    extends LapisPermission {
        Default() {
            super("Default");
        }
    }

    private class Priority
    extends LapisPermission {
        Priority() {
            super("Priority");
        }
    }

    public class PermissionManager {
        private ArrayList<LapisPermission> permissions = new ArrayList();

        protected void addPermission(LapisPermission permission) {
            this.permissions.add(permission);
        }

        protected List<LapisPermission> getPermissions() {
            return this.permissions;
        }

        public LapisPermission getPermission(String name) {
            for (LapisPermission permission : this.permissions) {
                if (!permission.getName().equalsIgnoreCase(name)) continue;
                return permission;
            }
            return null;
        }
    }
}

