/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.lapismc.lapiscore.LapisCorePlugin;
import net.lapismc.lapiscore.permissions.LapisPermission;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class LapisCoreCommand
extends BukkitCommand {
    private final LapisCorePlugin core;
    private TabCompleter tabCompleter;

    protected LapisCoreCommand(LapisCorePlugin core, String name, String desc, ArrayList<String> aliases) {
        this(core, name, desc, aliases, false);
    }

    protected LapisCoreCommand(LapisCorePlugin core, String name, String desc, ArrayList<String> aliases, boolean takeConflicts) {
        super(name);
        this.core = core;
        this.setDescription(desc);
        this.setAliases(aliases);
        this.setupCommand(name, takeConflicts);
    }

    private void setupCommand(String name, boolean takeConflicts) {
        if (takeConflicts) {
            Bukkit.getScheduler().runTask((Plugin)this.core, this::takeConflictingAliases);
        }
        this.registerCommand();
    }

    private void registerCommand() {
        try {
            Field serverCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            serverCommandMap.setAccessible(true);
            CommandMap commandMap = (CommandMap)serverCommandMap.get(Bukkit.getServer());
            commandMap.register(this.getName(), (Command)this);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private void takeConflictingAliases() {
        PluginCommand command;
        for (String alias : this.getAliases()) {
            if (Bukkit.getPluginCommand((String)alias) == null) continue;
            PluginCommand command2 = Bukkit.getPluginCommand((String)alias);
            command2.setExecutor((CommandExecutor)new LapisCoreCommandExecutor());
        }
        if (Bukkit.getPluginCommand((String)this.getName()) != null && !(command = Bukkit.getPluginCommand((String)this.getName())).getPlugin().equals((Object)this.core)) {
            command.setExecutor((CommandExecutor)new LapisCoreCommandExecutor());
        }
    }

    protected void registerTabCompleter(TabCompleter completer) {
        this.tabCompleter = completer;
    }

    protected boolean isPermitted(CommandSender sender, LapisPermission permission) {
        if (sender instanceof Player) {
            if (this.core.perms != null) {
                return this.core.perms.isPermitted(((Player)sender).getUniqueId(), permission);
            }
            return false;
        }
        return true;
    }

    protected void sendMessage(CommandSender sender, String key) {
        sender.sendMessage(this.core.config.getMessage(key));
    }

    protected boolean isNotPlayer(CommandSender sender, String key) {
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, key);
            return true;
        }
        return false;
    }

    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        this.onCommand(sender, commandLabel, args);
        return true;
    }

    protected void onCommand(CommandSender sender, String commandLabel, String[] args) {
        this.onCommand(sender, args);
    }

    protected abstract void onCommand(CommandSender var1, String[] var2);

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        if (this.tabCompleter == null) {
            return super.tabComplete(sender, alias, args);
        }
        return this.tabCompleter.onTabComplete(sender, (Command)this, alias, args);
    }

    private class LapisCoreCommandExecutor
    implements CommandExecutor {
        private LapisCoreCommandExecutor() {
        }

        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            return LapisCoreCommand.this.execute(sender, label, args);
        }
    }
}

