/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class LapisItemBuilder {
    Material mat;
    String name = "";
    int amount = 1;
    OfflinePlayer owner;
    List<String> lore = new ArrayList<String>();

    public LapisItemBuilder(Material mat) {
        this.mat = mat;
    }

    public LapisItemBuilder(OfflinePlayer offlinePlayer) {
        this.mat = Material.PLAYER_HEAD;
        this.owner = offlinePlayer;
    }

    public LapisItemBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public LapisItemBuilder setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    public LapisItemBuilder addLore(String ... lore) {
        this.lore.addAll(Arrays.asList(lore));
        return this;
    }

    public LapisItemBuilder setLore(String ... lore) {
        this.lore.clear();
        this.lore.addAll(Arrays.asList(lore));
        return this;
    }

    public LapisItemBuilder setWoolColor(WoolColor color) {
        this.mat = Material.getMaterial((String)(color.name() + "_WOOL"));
        return this;
    }

    public ItemStack build() {
        ItemStack i = new ItemStack(this.mat);
        ItemMeta meta = i.getItemMeta();
        if (meta != null) {
            if (this.name != null && !this.name.equals("")) {
                meta.setDisplayName(this.name);
            }
            if (this.owner != null && meta instanceof SkullMeta) {
                ((SkullMeta)meta).setOwningPlayer(this.owner);
            }
            if (!this.lore.isEmpty()) {
                meta.setLore(this.lore);
            }
            i.setItemMeta(meta);
        }
        i.setAmount(this.amount);
        return i;
    }

    public static enum WoolColor {
        WHITE,
        ORANGE,
        MAGENTA,
        LIGHT_BLUE,
        YELLOW,
        LIME,
        PINK,
        GRAY,
        LIGHT_GRAY,
        CYAN,
        PURPLE,
        BLUE,
        BROWN,
        GREEN,
        RED,
        BLACK;

    }
}

