/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore.commands.tabcomplete;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.lapismc.lapiscore.commands.LapisCoreCommand;
import net.lapismc.lapiscore.commands.tabcomplete.LapisTabOption;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class LapisCoreTabCompleter
implements TabCompleter {
    HashMap<LapisCoreCommand, List<LapisTabOption>> topLevelOptions = new HashMap();

    public void registerTopLevelOptions(LapisCoreCommand command, List<LapisTabOption> options) {
        this.topLevelOptions.put(command, options);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!(command instanceof LapisCoreCommand)) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        List<LapisTabOption> options = this.topLevelOptions.get(command);
        if (args.length == 0) {
            for (LapisTabOption option : options) {
                result.addAll(option.getOptions(sender));
            }
        } else {
            return this.recursiveSearch(options, sender, new ArrayList<String>(List.of(args)));
        }
        return result;
    }

    private List<String> recursiveSearch(List<LapisTabOption> options, CommandSender sender, List<String> args) {
        ArrayList<String> result = new ArrayList<String>();
        if (options == null || options.isEmpty() || args.isEmpty()) {
            return result;
        }
        for (LapisTabOption option : options) {
            for (String s : option.getOptions(sender)) {
                if (s.equalsIgnoreCase(args.get(0))) {
                    List<LapisTabOption> children = option.getChildren(sender);
                    ArrayList<String> clonedArgs = new ArrayList<String>(args);
                    clonedArgs.remove(0);
                    return this.recursiveSearch(children, sender, clonedArgs);
                }
                if (s.startsWith("(") && s.endsWith(")")) {
                    result.add(s);
                    continue;
                }
                if (!s.toLowerCase().startsWith(args.get(0).toLowerCase())) continue;
                result.add(s);
            }
        }
        return result;
    }
}

