/*
 * Decompiled with CFR 0.152.
 */
package net.ksmr.sched;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;

public class Sched {
    private static boolean supported = false;

    private Sched() {
    }

    public static void setAffinity(long mask) {
        if (!supported) {
            throw new UnsupportedOperationException();
        }
        Sched.linux_sched_setaffinity(mask);
    }

    public static void setAffinityBitSet(BitSet mask) {
        if (!supported) {
            throw new UnsupportedOperationException();
        }
        Sched.linux_sched_setaffinity_dynamic(mask.toLongArray());
    }

    public static long getAffinity() {
        if (!supported) {
            throw new UnsupportedOperationException();
        }
        return Sched.linux_sched_getaffinity();
    }

    public static BitSet getAffinityBitSet() {
        if (!supported) {
            throw new UnsupportedOperationException();
        }
        return BitSet.valueOf(Sched.linux_sched_getaffinity_dynamic());
    }

    private static native void linux_sched_setaffinity(long var0);

    private static native void linux_sched_setaffinity_dynamic(long[] var0);

    private static native long linux_sched_getaffinity();

    private static native long[] linux_sched_getaffinity_dynamic();

    private static boolean checkSupport() {
        return System.getProperty("os.name").contains("Linux");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadNative(String name) throws IOException {
        InputStream in = Sched.class.getClassLoader().getResourceAsStream(name);
        if (in == null) {
            throw new UnsupportedOperationException();
        }
        int pos = name.lastIndexOf(".");
        File tmpFile = File.createTempFile(name.substring(0, pos), name.substring(pos));
        tmpFile.deleteOnExit();
        try {
            byte[] buffer = new byte[4096];
            try (FileOutputStream out = new FileOutputStream(tmpFile);){
                while (in.available() > 0) {
                    int len = in.read(buffer);
                    if (len < 0) continue;
                    ((OutputStream)out).write(buffer, 0, len);
                }
            }
        }
        finally {
            in.close();
        }
        System.load(tmpFile.toString());
    }

    static {
        supported = Sched.checkSupport();
        if (supported) {
            try {
                Sched.loadNative("libsched-" + System.getProperty("os.arch") + ".so");
            }
            catch (Exception e) {
                supported = false;
            }
        }
    }
}

