/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.tasks;

import java.util.Calendar;
import java.util.TimeZone;
import java.util.TimerTask;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.krotscheck.kangaroo.common.hibernate.migration.DatabaseMigrationState;
import net.krotscheck.kangaroo.common.timedtasks.RepeatingTask;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenCleanupTask
extends TimerTask
implements RepeatingTask {
    private static Logger logger = LoggerFactory.getLogger(TokenCleanupTask.class);
    private final SessionFactory sessionFactory;
    private final DatabaseMigrationState migrationState;

    @Inject
    public TokenCleanupTask(SessionFactory sessionFactory, DatabaseMigrationState dbState) {
        this.sessionFactory = sessionFactory;
        this.migrationState = dbState;
    }

    public TimerTask getTask() {
        return this;
    }

    public long getPeriod() {
        return 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Session session = this.sessionFactory.openSession();
        Transaction t = session.beginTransaction();
        long deletedCount = 0L;
        try {
            Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            now.add(12, -1);
            Long timestamp = now.getTimeInMillis();
            String hql = "DELETE FROM OAuthToken WHERE (createdDate + (expiresIn * 1000)) < :timestamp";
            deletedCount = session.createQuery(hql).setParameter("timestamp", (Object)timestamp, (Type)LongType.INSTANCE).executeUpdate();
            t.commit();
        }
        catch (HibernateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            t.rollback();
        }
        finally {
            session.close();
        }
        if (deletedCount > 0L) {
            logger.debug(String.format("%s expired tokens deleted.", deletedCount));
        }
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(TokenCleanupTask.class).to(RepeatingTask.class)).in(Singleton.class);
        }
    }
}

