/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.session.grizzly;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import net.krotscheck.kangaroo.authz.AuthzServerConfig;
import net.krotscheck.kangaroo.authz.common.database.entity.HttpSession;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.oauth2.session.grizzly.GrizzlySession;
import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.SessionManager;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.hibernate.SessionFactory;

public final class GrizzlySessionManager
implements SessionManager {
    private final Integer sessionMaxAge;
    private final Provider<SessionFactory> sessionFactoryProvider;
    private String sessionCookieName;

    @Inject
    public GrizzlySessionManager(SystemConfiguration c, Provider<SessionFactory> sfProvider) {
        this.sessionFactoryProvider = sfProvider;
        this.sessionMaxAge = c.getInt(AuthzServerConfig.SESSION_MAX_AGE.getKey(), AuthzServerConfig.SESSION_MAX_AGE.getValue().intValue());
        this.sessionCookieName = c.getString(AuthzServerConfig.SESSION_NAME.getKey(), AuthzServerConfig.SESSION_NAME.getValue());
    }

    public Session getSession(Request request, String requestedSessionId) {
        BigInteger sessionId = IdUtil.fromString((String)requestedSessionId);
        if (sessionId != null) {
            SessionFactory sessionFactory = (SessionFactory)this.sessionFactoryProvider.get();
            org.hibernate.Session hibernateSession = sessionFactory.openSession();
            hibernateSession.beginTransaction();
            HttpSession entity = (HttpSession)((Object)hibernateSession.get(HttpSession.class, (Serializable)sessionId));
            hibernateSession.getTransaction().commit();
            if (entity != null) {
                Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                entity.setModifiedDate(now);
                hibernateSession.beginTransaction();
                hibernateSession.update((Object)entity);
                hibernateSession.getTransaction().commit();
            }
            hibernateSession.close();
            return this.asSession(entity);
        }
        return null;
    }

    public Session createSession(Request request) {
        SessionFactory sessionFactory = (SessionFactory)this.sessionFactoryProvider.get();
        org.hibernate.Session hibernateSession = sessionFactory.openSession();
        hibernateSession.beginTransaction();
        HttpSession entity = new HttpSession();
        entity.setSessionTimeout(this.sessionMaxAge.intValue());
        hibernateSession.save((Object)entity);
        hibernateSession.getTransaction().commit();
        hibernateSession.close();
        return this.asSession(entity);
    }

    public String changeSessionId(Request request, Session session) {
        String oldId = session.getIdInternal();
        GrizzlySession grizzlySession = (GrizzlySession)session;
        SessionFactory sessionFactory = (SessionFactory)this.sessionFactoryProvider.get();
        org.hibernate.Session hibernateSession = sessionFactory.openSession();
        try {
            BigInteger old = IdUtil.fromString((String)session.getIdInternal());
            hibernateSession.beginTransaction();
            HttpSession oldEntity = (HttpSession)((Object)hibernateSession.get(HttpSession.class, (Serializable)old));
            hibernateSession.getTransaction().commit();
            if (oldEntity != null) {
                hibernateSession.beginTransaction();
                ArrayList<OAuthToken> refreshTokens = new ArrayList<OAuthToken>(oldEntity.getRefreshTokens());
                HttpSession newSession = new HttpSession();
                newSession.setSessionTimeout(session.getSessionTimeout());
                newSession.setRefreshTokens(refreshTokens);
                hibernateSession.delete((Object)oldEntity);
                hibernateSession.save((Object)newSession);
                hibernateSession.getTransaction().commit();
                grizzlySession.setIdInternal(IdUtil.toString((BigInteger)newSession.getId()));
            }
        }
        catch (Exception e) {
            hibernateSession.getTransaction().rollback();
        }
        hibernateSession.close();
        return oldId;
    }

    public String getSessionCookieName() {
        return this.sessionCookieName;
    }

    public void setSessionCookieName(String name) {
        this.sessionCookieName = name;
    }

    public void configureSessionCookie(Request request, Cookie cookie) {
        String requestUrlString = request.getRequestURL().toString();
        URI requestUrl = URI.create(requestUrlString);
        cookie.setDomain(requestUrl.getHost());
        cookie.setHttpOnly(true);
        cookie.setSecure(true);
        cookie.setName(this.sessionCookieName);
        cookie.setMaxAge(this.sessionMaxAge.intValue());
        cookie.setVersion(1);
    }

    protected Session asSession(HttpSession entity) {
        if (entity == null) {
            return null;
        }
        GrizzlySession s = new GrizzlySession();
        s.setIdInternal(IdUtil.toString((BigInteger)entity.getId()));
        s.setCreationTime(entity.getCreatedDate().getTimeInMillis());
        s.setTimestamp(entity.getModifiedDate().getTimeInMillis());
        s.setSessionTimeout(entity.getSessionTimeout());
        return s;
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(GrizzlySessionManager.class).to(GrizzlySessionManager.class)).in(Singleton.class);
        }
    }
}

