/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.session.grizzly;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import net.krotscheck.kangaroo.authz.AuthzServerConfig;
import net.krotscheck.kangaroo.authz.oauth2.session.grizzly.GrizzlySessionManager;
import net.krotscheck.kangaroo.common.config.SystemConfiguration;
import org.glassfish.grizzly.http.server.SessionManager;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

@Provider
@Singleton
public final class GrizzlySessionLifecycleListener
implements ContainerLifecycleListener {
    private final WebappContext context;
    private final GrizzlySessionManager sessionManager;
    private final Integer sessionMaxAge;
    private final String sessionName;

    @Inject
    public GrizzlySessionLifecycleListener(@Context ServletContext context, GrizzlySessionManager sessionManager, SystemConfiguration c) {
        this.context = (WebappContext)context;
        this.sessionManager = sessionManager;
        this.sessionMaxAge = c.getInt(AuthzServerConfig.SESSION_MAX_AGE.getKey(), AuthzServerConfig.SESSION_MAX_AGE.getValue().intValue());
        this.sessionName = c.getString(AuthzServerConfig.SESSION_NAME.getKey(), AuthzServerConfig.SESSION_NAME.getValue());
    }

    public void onStartup(Container container) {
        this.context.setSessionManager((SessionManager)this.sessionManager);
        this.context.getSessionCookieConfig().setName(this.sessionName);
        this.context.getSessionCookieConfig().setHttpOnly(true);
        this.context.getSessionCookieConfig().setSecure(true);
        this.context.getSessionCookieConfig().setMaxAge(this.sessionMaxAge.intValue());
    }

    public void onReload(Container container) {
    }

    public void onShutdown(Container container) {
    }
}

