/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource.token;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.SortedMap;
import javax.inject.Inject;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.util.ValidationUtil;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Session;

public final class RefreshTokenGrantHandler {
    private final Session session;

    @Inject
    public RefreshTokenGrantHandler(Session session) {
        this.session = session;
    }

    public TokenResponseEntity handle(Client client, String scope, String state, BigInteger refreshId) {
        ClientType type = client.getType();
        if (!type.equals((Object)ClientType.OwnerCredentials) && !type.equals((Object)ClientType.AuthorizationGrant)) {
            throw new RFC6749.InvalidGrantException();
        }
        if (refreshId == null) {
            throw new RFC6749.InvalidGrantException();
        }
        OAuthToken refreshToken = (OAuthToken)this.session.get(OAuthToken.class, (Serializable)refreshId);
        if (refreshToken == null || !refreshToken.getTokenType().equals((Object)OAuthTokenType.Refresh)) {
            throw new RFC6749.InvalidGrantException();
        }
        if (refreshToken.isExpired()) {
            throw new RFC6749.InvalidGrantException();
        }
        SortedMap<String, ApplicationScope> requestedScopes = ValidationUtil.revalidateScope(scope, refreshToken.getScopes(), refreshToken.getIdentity().getUser().getRole());
        OAuthToken newAuthToken = new OAuthToken();
        newAuthToken.setClient(client);
        newAuthToken.setTokenType(OAuthTokenType.Bearer);
        newAuthToken.setExpiresIn(client.getAccessTokenExpireIn());
        newAuthToken.setScopes(requestedScopes);
        newAuthToken.setIdentity(refreshToken.getIdentity());
        newAuthToken.setIssuer(refreshToken.getIssuer());
        OAuthToken newRefreshToken = new OAuthToken();
        newRefreshToken.setClient(client);
        newRefreshToken.setTokenType(OAuthTokenType.Refresh);
        newRefreshToken.setExpiresIn(client.getRefreshTokenExpireIn());
        newRefreshToken.setScopes(requestedScopes);
        newRefreshToken.setIdentity(refreshToken.getIdentity());
        newRefreshToken.setAuthToken(newAuthToken);
        newRefreshToken.setIssuer(refreshToken.getIssuer());
        this.session.save((Object)newAuthToken);
        this.session.save((Object)newRefreshToken);
        if (refreshToken.getAuthToken() != null) {
            this.session.delete((Object)refreshToken.getAuthToken());
        }
        this.session.delete((Object)refreshToken);
        return TokenResponseEntity.factory(newAuthToken, newRefreshToken, state);
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(RefreshTokenGrantHandler.class).to(RefreshTokenGrantHandler.class)).in(RequestScoped.class);
        }
    }
}

