/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource.token;

import java.util.SortedMap;
import javax.inject.Inject;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.authenticator.password.PasswordAuthenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.common.util.ValidationUtil;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Session;

public final class OwnerCredentialsGrantHandler {
    private final Session session;
    private final UriInfo uriInfo;
    private final InjectionManager injector;

    @Inject
    public OwnerCredentialsGrantHandler(Session session, @Context UriInfo uriInfo, InjectionManager injector) {
        this.session = session;
        this.uriInfo = uriInfo;
        this.injector = injector;
    }

    public TokenResponseEntity handle(Client client, String scope, String state, String username, String password) {
        if (!client.getType().equals((Object)ClientType.OwnerCredentials)) {
            throw new RFC6749.InvalidGrantException();
        }
        IAuthenticator authenticator = (IAuthenticator)this.injector.getInstance(PasswordAuthenticator.class);
        Authenticator authConfig = ValidationUtil.validateAuthenticator(AuthenticatorType.Password, client.getAuthenticators());
        MultivaluedStringMap formData = new MultivaluedStringMap();
        formData.putSingle((Object)"username", (Object)username);
        formData.putSingle((Object)"password", (Object)password);
        UserIdentity identity = authenticator.authenticate(authConfig, (MultivaluedMap<String, String>)formData, null);
        if (identity == null) {
            throw new NotAuthorizedException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
        SortedMap<String, ApplicationScope> requestedScopes = ValidationUtil.validateScope(scope, identity.getUser().getRole());
        OAuthToken token = new OAuthToken();
        token.setClient(client);
        token.setTokenType(OAuthTokenType.Bearer);
        token.setExpiresIn(client.getAccessTokenExpireIn());
        token.setScopes(requestedScopes);
        token.setIdentity(identity);
        token.setIssuer(this.uriInfo.getAbsolutePath().getHost());
        OAuthToken refreshToken = new OAuthToken();
        refreshToken.setClient(client);
        refreshToken.setTokenType(OAuthTokenType.Refresh);
        refreshToken.setExpiresIn(client.getRefreshTokenExpireIn());
        refreshToken.setScopes(token.getScopes());
        refreshToken.setAuthToken(token);
        refreshToken.setIdentity(identity);
        refreshToken.setIssuer(this.uriInfo.getAbsolutePath().getHost());
        this.session.save((Object)token);
        this.session.save((Object)refreshToken);
        return TokenResponseEntity.factory(token, refreshToken, state);
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(OwnerCredentialsGrantHandler.class).to(OwnerCredentialsGrantHandler.class)).in(RequestScoped.class);
        }
    }
}

