/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource.token;

import java.util.SortedMap;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.util.ValidationUtil;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Session;

public final class ClientCredentialsGrantHandler {
    private final Session session;
    private final UriInfo uriInfo;

    @Inject
    public ClientCredentialsGrantHandler(Session session, @Context UriInfo uriInfo) {
        this.session = session;
        this.uriInfo = uriInfo;
    }

    public TokenResponseEntity handle(Client client, String scope, String state) {
        if (!client.getType().equals((Object)ClientType.ClientCredentials)) {
            throw new RFC6749.InvalidGrantException();
        }
        if (StringUtils.isEmpty((CharSequence)client.getClientSecret())) {
            throw new RFC6749.UnauthorizedClientException();
        }
        SortedMap<String, ApplicationScope> requestedScopes = ValidationUtil.validateScope(scope, client.getApplication().getScopes());
        OAuthToken token = new OAuthToken();
        token.setClient(client);
        token.setTokenType(OAuthTokenType.Bearer);
        token.setExpiresIn(client.getAccessTokenExpireIn());
        token.setScopes(requestedScopes);
        token.setIssuer(this.uriInfo.getAbsolutePath().getHost());
        this.session.save((Object)token);
        return TokenResponseEntity.factory(token, state);
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(ClientCredentialsGrantHandler.class).to(ClientCredentialsGrantHandler.class)).in(RequestScoped.class);
        }
    }
}

