/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource.token;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Session;

public final class AuthorizationCodeGrantHandler {
    private final Session session;
    private final UriInfo uriInfo;

    @Inject
    public AuthorizationCodeGrantHandler(Session session, @Context UriInfo uriInfo) {
        this.session = session;
        this.uriInfo = uriInfo;
    }

    public TokenResponseEntity handle(Client client, BigInteger authCodeId, URI redirect, String state) {
        if (!client.getType().equals((Object)ClientType.AuthorizationGrant)) {
            throw new RFC6749.InvalidGrantException();
        }
        if (authCodeId == null || redirect == null) {
            throw new RFC6749.InvalidRequestException();
        }
        OAuthToken authCode = (OAuthToken)this.session.get(OAuthToken.class, (Serializable)authCodeId);
        if (authCode == null) {
            throw new RFC6749.InvalidGrantException();
        }
        if (authCode.isExpired()) {
            throw new RFC6749.InvalidGrantException();
        }
        if (!authCode.getClient().equals((Object)client)) {
            throw new RFC6749.InvalidGrantException();
        }
        if (!redirect.equals(authCode.getRedirect())) {
            throw new RFC6749.InvalidGrantException();
        }
        OAuthToken newAuthToken = new OAuthToken();
        newAuthToken.setClient(client);
        newAuthToken.setTokenType(OAuthTokenType.Bearer);
        newAuthToken.setExpiresIn(client.getAccessTokenExpireIn());
        newAuthToken.setScopes(authCode.getScopes());
        newAuthToken.setIdentity(authCode.getIdentity());
        newAuthToken.setIssuer(this.uriInfo.getAbsolutePath().getHost());
        OAuthToken newRefreshToken = new OAuthToken();
        newRefreshToken.setClient(client);
        newRefreshToken.setTokenType(OAuthTokenType.Refresh);
        newRefreshToken.setExpiresIn(client.getRefreshTokenExpireIn());
        newRefreshToken.setScopes(authCode.getScopes());
        newRefreshToken.setAuthToken(newAuthToken);
        newRefreshToken.setIdentity(authCode.getIdentity());
        newRefreshToken.setIssuer(this.uriInfo.getAbsolutePath().getHost());
        this.session.save((Object)newAuthToken);
        this.session.save((Object)newRefreshToken);
        this.session.delete((Object)authCode);
        return TokenResponseEntity.factory(newAuthToken, newRefreshToken, state);
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)this.bind(AuthorizationCodeGrantHandler.class).to(AuthorizationCodeGrantHandler.class)).in(RequestScoped.class);
        }
    }
}

