/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource.authorize;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.AuthenticatorState;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.common.util.ValidationUtil;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.resource.authorize.IAuthorizeHandler;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.util.ObjectUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Session;

public final class ImplicitHandler
implements IAuthorizeHandler {
    private final InjectionManager injector;
    private final Session session;
    private final SecurityContext securityContext;
    private final UriInfo uriInfo;

    @Inject
    public ImplicitHandler(InjectionManager injector, Session session, SecurityContext securityContext, @Context UriInfo uriInfo) {
        this.injector = injector;
        this.session = session;
        this.securityContext = securityContext;
        this.uriInfo = uriInfo;
    }

    @Override
    public IAuthenticator getAuthenticator(AuthenticatorState state) {
        Authenticator a = state.getAuthenticator();
        return (IAuthenticator)this.injector.getInstance(IAuthenticator.class, a.getType().name());
    }

    @Override
    public Response handle(HttpSession browserSession, Authenticator auth, URI redirect, SortedMap<String, ApplicationScope> scopes, String state) {
        List<OAuthToken> refreshTokens = this.getContextToken(browserSession);
        if (refreshTokens.size() == 1) {
            OAuthToken refreshToken = refreshTokens.get(0);
            return this.handleRefresh(refreshToken, browserSession, redirect, scopes, state);
        }
        if (refreshTokens.size() > 1) {
            refreshTokens.forEach(arg_0 -> ((Session)this.session).delete(arg_0));
        }
        return this.handleIssue(auth, redirect, scopes, state);
    }

    private Response handleIssue(Authenticator auth, URI redirect, SortedMap<String, ApplicationScope> scopes, String state) {
        IAuthenticator authImpl = (IAuthenticator)this.injector.getInstance(IAuthenticator.class, auth.getType().name());
        AuthenticatorState callbackState = new AuthenticatorState();
        callbackState.setClientState(state);
        callbackState.setClientScopes(scopes);
        callbackState.setClientRedirect(redirect);
        callbackState.setAuthenticator(auth);
        this.session.save((Object)callbackState);
        URI callback = this.buildCallback(this.uriInfo, callbackState);
        return authImpl.delegate(auth, callback);
    }

    private Response handleRefresh(OAuthToken oldRefreshToken, HttpSession browserSession, URI redirect, SortedMap<String, ApplicationScope> requestedScopes, String state) {
        String simulatedScopeRequest = String.join((CharSequence)" ", requestedScopes.keySet());
        SortedMap<String, ApplicationScope> issuableScopes = ValidationUtil.revalidateScope(simulatedScopeRequest, oldRefreshToken.getScopes(), oldRefreshToken.getIdentity().getUser().getRole());
        OAuthToken newBearerToken = this.buildBearerToken(oldRefreshToken.getClient(), oldRefreshToken.getIdentity(), issuableScopes, redirect);
        OAuthToken newRefreshToken = this.buildRefreshToken(newBearerToken);
        net.krotscheck.kangaroo.authz.common.database.entity.HttpSession dbSession = this.getDbSession(browserSession);
        dbSession.getRefreshTokens().remove(oldRefreshToken);
        oldRefreshToken.setHttpSession(null);
        dbSession.getRefreshTokens().add(newRefreshToken);
        newRefreshToken.setHttpSession(dbSession);
        this.session.save((Object)newBearerToken);
        this.session.save((Object)newRefreshToken);
        if (oldRefreshToken.getAuthToken() != null) {
            this.session.delete((Object)oldRefreshToken.getAuthToken());
        }
        this.session.delete((Object)oldRefreshToken);
        this.session.getTransaction().commit();
        return this.buildRedirectResponse(redirect, state, newBearerToken);
    }

    @Override
    public Response callback(AuthenticatorState s, HttpSession browserSession) {
        URI callback = this.buildCallback(this.uriInfo, s);
        IAuthenticator a = this.getAuthenticator(s);
        UserIdentity identity = a.authenticate(s.getAuthenticator(), (MultivaluedMap<String, String>)this.uriInfo.getPathParameters(), callback);
        Client client = s.getAuthenticator().getClient();
        SortedMap<String, ApplicationScope> issuedScopes = ValidationUtil.validateScope(s.getClientScopes(), identity.getUser().getRole());
        OAuthToken accessToken = this.buildBearerToken(client, identity, issuedScopes, s.getClientRedirect());
        OAuthToken refreshToken = this.buildRefreshToken(accessToken);
        net.krotscheck.kangaroo.authz.common.database.entity.HttpSession dbSession = this.getDbSession(browserSession);
        refreshToken.setHttpSession(dbSession);
        this.session.delete((Object)s);
        this.session.save((Object)accessToken);
        this.session.save((Object)refreshToken);
        this.session.getTransaction().commit();
        return this.buildRedirectResponse(s.getClientRedirect(), s.getClientState(), accessToken);
    }

    private Response buildRedirectResponse(URI clientRedirect, String clientState, OAuthToken accessToken) {
        UriBuilder responseBuilder = UriBuilder.fromUri((URI)clientRedirect);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("access_token", IdUtil.toString((BigInteger)accessToken.getId())));
        params.add(new BasicNameValuePair("token_type", accessToken.getTokenType().toString()));
        params.add(new BasicNameValuePair("expires_in", String.valueOf(accessToken.getExpiresIn())));
        if (!StringUtils.isEmpty((CharSequence)clientState)) {
            params.add(new BasicNameValuePair("state", clientState));
        }
        if (accessToken.getScopes().size() > 0) {
            String scopeString = accessToken.getScopes().values().stream().map(ApplicationScope::getName).collect(Collectors.joining(" "));
            params.add(new BasicNameValuePair("scope", scopeString));
        }
        responseBuilder.fragment(URLEncodedUtils.format(params, (String)"UTF-8"));
        return Response.status((Response.Status)Response.Status.FOUND).location(responseBuilder.build(new Object[0])).build();
    }

    private OAuthToken buildBearerToken(Client client, UserIdentity identity, SortedMap<String, ApplicationScope> issuedScopes, URI redirect) {
        OAuthToken bearerToken = new OAuthToken();
        bearerToken.setClient(client);
        bearerToken.setTokenType(OAuthTokenType.Bearer);
        bearerToken.setExpiresIn(client.getAccessTokenExpireIn());
        bearerToken.setScopes(issuedScopes);
        bearerToken.setIdentity(identity);
        bearerToken.setRedirect(redirect);
        return bearerToken;
    }

    private OAuthToken buildRefreshToken(OAuthToken bearerToken) {
        Client client = bearerToken.getClient();
        OAuthToken newRefreshToken = new OAuthToken();
        newRefreshToken.setClient(client);
        newRefreshToken.setTokenType(OAuthTokenType.Refresh);
        newRefreshToken.setExpiresIn(client.getRefreshTokenExpireIn());
        newRefreshToken.setScopes(bearerToken.getScopes());
        newRefreshToken.setIdentity(bearerToken.getIdentity());
        newRefreshToken.setAuthToken(bearerToken);
        newRefreshToken.setRedirect(bearerToken.getRedirect());
        return newRefreshToken;
    }

    private net.krotscheck.kangaroo.authz.common.database.entity.HttpSession getDbSession(HttpSession browserSession) {
        BigInteger sessionId = IdUtil.fromString((String)browserSession.getId());
        return (net.krotscheck.kangaroo.authz.common.database.entity.HttpSession)((Object)this.session.get(net.krotscheck.kangaroo.authz.common.database.entity.HttpSession.class, (Serializable)sessionId));
    }

    private List<OAuthToken> getContextToken(HttpSession browserSession) {
        net.krotscheck.kangaroo.authz.common.database.entity.HttpSession httpSession = this.getDbSession(browserSession);
        O2Principal principal = (O2Principal)ObjectUtil.safeCast((Object)this.securityContext.getUserPrincipal(), O2Principal.class).orElseThrow(RFC6749.AccessDeniedException::new);
        Client c = principal.getContext();
        return httpSession.getRefreshTokens().stream().filter(t -> t.getClient().equals((Object)c)).filter(t -> t.getTokenType().equals((Object)OAuthTokenType.Refresh)).filter(t -> !t.isExpired()).collect(Collectors.toList());
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(ImplicitHandler.class).to(IAuthorizeHandler.class)).named(ClientType.Implicit.name())).in(RequestScoped.class);
        }
    }
}

