/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource.authorize;

import java.math.BigInteger;
import java.net.URI;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.common.authenticator.IAuthenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.AuthenticatorState;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;
import net.krotscheck.kangaroo.authz.common.database.entity.UserIdentity;
import net.krotscheck.kangaroo.authz.common.util.ValidationUtil;
import net.krotscheck.kangaroo.authz.oauth2.resource.authorize.IAuthorizeHandler;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.hibernate.Session;

public final class AuthCodeHandler
implements IAuthorizeHandler {
    private final InjectionManager injector;
    private final Session session;
    private final UriInfo uriInfo;

    @Inject
    public AuthCodeHandler(InjectionManager injector, Session session, @Context UriInfo uriInfo) {
        this.injector = injector;
        this.session = session;
        this.uriInfo = uriInfo;
    }

    @Override
    public IAuthenticator getAuthenticator(AuthenticatorState state) {
        Authenticator a = state.getAuthenticator();
        return (IAuthenticator)this.injector.getInstance(IAuthenticator.class, a.getType().name());
    }

    @Override
    public Response handle(HttpSession browserSession, Authenticator auth, URI redirect, SortedMap<String, ApplicationScope> scopes, String state) {
        IAuthenticator authImpl = (IAuthenticator)this.injector.getInstance(IAuthenticator.class, auth.getType().name());
        AuthenticatorState callbackState = new AuthenticatorState();
        callbackState.setClientState(state);
        callbackState.setClientScopes(scopes);
        callbackState.setClientRedirect(redirect);
        callbackState.setAuthenticator(auth);
        this.session.save((Object)callbackState);
        URI callback = this.buildCallback(this.uriInfo, callbackState);
        return authImpl.delegate(auth, callback);
    }

    @Override
    public Response callback(AuthenticatorState s, HttpSession browserSession) {
        URI callback = this.buildCallback(this.uriInfo, s);
        IAuthenticator a = this.getAuthenticator(s);
        UserIdentity i = a.authenticate(s.getAuthenticator(), (MultivaluedMap<String, String>)this.uriInfo.getQueryParameters(), callback);
        OAuthToken t = new OAuthToken();
        t.setClient(s.getAuthenticator().getClient());
        t.setIdentity(i);
        t.setScopes(ValidationUtil.validateScope(s.getClientScopes(), i.getUser().getRole()));
        t.setTokenType(OAuthTokenType.Authorization);
        t.setExpiresIn(s.getAuthenticator().getClient().getAuthorizationCodeExpiresIn());
        t.setRedirect(s.getClientRedirect());
        t.setIdentity(i);
        t.setIssuer(this.uriInfo.getAbsolutePath().getHost());
        this.session.save((Object)t);
        this.session.delete((Object)s);
        UriBuilder responseBuilder = UriBuilder.fromUri((URI)s.getClientRedirect());
        responseBuilder.queryParam("code", new Object[]{IdUtil.toString((BigInteger)t.getId())});
        if (!StringUtils.isEmpty((CharSequence)s.getClientState())) {
            responseBuilder.queryParam("state", new Object[]{s.getClientState()});
        }
        return Response.status((Response.Status)Response.Status.FOUND).location(responseBuilder.build(new Object[0])).build();
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(AuthCodeHandler.class).to(IAuthorizeHandler.class)).named(ClientType.AuthorizationGrant.name())).in(RequestScoped.class);
        }
    }
}

