/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigInteger;
import java.net.URI;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.resource.GrantType;
import net.krotscheck.kangaroo.authz.oauth2.resource.TokenResponseEntity;
import net.krotscheck.kangaroo.authz.oauth2.resource.token.AuthorizationCodeGrantHandler;
import net.krotscheck.kangaroo.authz.oauth2.resource.token.ClientCredentialsGrantHandler;
import net.krotscheck.kangaroo.authz.oauth2.resource.token.OwnerCredentialsGrantHandler;
import net.krotscheck.kangaroo.authz.oauth2.resource.token.RefreshTokenGrantHandler;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.util.ObjectUtil;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.jvnet.hk2.annotations.Optional;

@Path(value="/token")
@Transactional
@Api(tags={"OAuth2"})
public final class TokenService {
    private final SecurityContext securityContext;
    private final InjectionManager injector;

    @Inject
    public TokenService(SecurityContext securityContext, InjectionManager injector) {
        this.securityContext = securityContext;
        this.injector = injector;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @ApiOperation(value="OAuth2 Token endpoint.")
    @ApiParam(name="token")
    @O2Client
    public Response tokenRequest(@Context UriInfo uriInfo, @ApiParam(type="string") @Optional @FormParam(value="code") BigInteger code, @Optional @FormParam(value="redirect_uri") URI redirect, @Optional @FormParam(value="state") String state, @Optional @FormParam(value="scope") String scope, @Optional @FormParam(value="username") String username, @Optional @FormParam(value="password") String password, @ApiParam(type="string") @Optional @FormParam(value="refresh_token") BigInteger refreshToken, @ApiParam(required=true, allowableValues="authorization_code,client_credentials,password,refresh_token") @FormParam(value="grant_type") GrantType grantType) {
        O2Principal principal = (O2Principal)ObjectUtil.safeCast((Object)this.securityContext.getUserPrincipal(), O2Principal.class).orElseThrow(RFC6749.AccessDeniedException::new);
        Client client = principal.getContext();
        TokenResponseEntity tokenResponse = null;
        if (GrantType.AuthorizationCode.equals((Object)grantType)) {
            AuthorizationCodeGrantHandler handler = (AuthorizationCodeGrantHandler)this.injector.getInstance(AuthorizationCodeGrantHandler.class);
            tokenResponse = handler.handle(client, code, redirect, state);
        } else if (GrantType.ClientCredentials.equals((Object)grantType)) {
            ClientCredentialsGrantHandler clientHandler = (ClientCredentialsGrantHandler)this.injector.getInstance(ClientCredentialsGrantHandler.class);
            tokenResponse = clientHandler.handle(client, scope, state);
        } else if (GrantType.Password.equals((Object)grantType)) {
            OwnerCredentialsGrantHandler passwordHandler = (OwnerCredentialsGrantHandler)this.injector.getInstance(OwnerCredentialsGrantHandler.class);
            tokenResponse = passwordHandler.handle(client, scope, state, username, password);
        } else if (GrantType.RefreshToken.equals((Object)grantType)) {
            RefreshTokenGrantHandler refreshHandler = (RefreshTokenGrantHandler)this.injector.getInstance(RefreshTokenGrantHandler.class);
            tokenResponse = refreshHandler.handle(client, scope, state, refreshToken);
        } else {
            throw new RFC6749.InvalidGrantException();
        }
        return Response.ok().entity((Object)tokenResponse).build();
    }
}

