/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.ArrayList;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class TokenResponseEntity {
    @JsonProperty(value="access_token")
    private BigInteger accessToken;
    @JsonProperty(value="token_type")
    private OAuthTokenType tokenType;
    @JsonProperty(value="expires_in")
    private Long expiresIn;
    @JsonProperty(value="refresh_token")
    private BigInteger refreshToken;
    @JsonProperty(value="scope")
    private String scope;
    @JsonProperty(value="state")
    private String state;

    private TokenResponseEntity() {
    }

    public static TokenResponseEntity factory(OAuthToken token, String state) {
        TokenResponseEntity t = new TokenResponseEntity();
        t.accessToken = token.getId();
        t.tokenType = token.getTokenType();
        t.expiresIn = token.getExpiresIn();
        t.state = state;
        ArrayList scopes = new ArrayList();
        token.getScopes().forEach((n, s) -> scopes.add(n));
        if (scopes.size() > 0) {
            t.scope = String.join((CharSequence)" ", scopes);
        }
        return t;
    }

    public static TokenResponseEntity factory(OAuthToken token, OAuthToken refresh, String state) {
        TokenResponseEntity t = TokenResponseEntity.factory(token, state);
        t.refreshToken = refresh.getId();
        return t;
    }

    public BigInteger getAccessToken() {
        return this.accessToken;
    }

    public OAuthTokenType getTokenType() {
        return this.tokenType;
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }

    public BigInteger getRefreshToken() {
        return this.refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public String getState() {
        return this.state;
    }
}

