/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Optional;
import javax.annotation.security.PermitAll;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2AuthScheme;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2BearerToken;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.resource.IntrospectionResponseEntity;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.util.ObjectUtil;
import org.hibernate.Session;

@Path(value="/introspect")
@PermitAll
@Transactional
@Api(tags={"OAuth2"})
public final class IntrospectionService {
    private final Session session;
    private final SecurityContext securityContext;

    @Inject
    public IntrospectionService(Session session, SecurityContext securityContext) {
        this.session = session;
        this.securityContext = securityContext;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @O2Client(permitPublic=false)
    @O2BearerToken
    @ApiOperation(value="OAuth2 Introspection endpoint.")
    public Response introspectionRequest(@ApiParam(type="string") @FormParam(value="token") BigInteger tokenId) {
        OAuthToken introspectedToken;
        O2Principal principal = (O2Principal)ObjectUtil.safeCast((Object)this.securityContext.getUserPrincipal(), O2Principal.class).orElseThrow(RFC6749.AccessDeniedException::new);
        O2AuthScheme scheme = O2AuthScheme.valueOf(principal.getScheme());
        if (scheme.equals((Object)O2AuthScheme.BearerToken)) {
            introspectedToken = Optional.ofNullable(principal.getOAuthToken()).filter(t -> t.getId().equals(tokenId)).orElse(null);
        } else {
            Client client = principal.getContext();
            introspectedToken = Optional.ofNullable(tokenId).map(id -> (OAuthToken)this.session.get(OAuthToken.class, (Serializable)id)).filter(token -> token.getClient().getApplication().equals((Object)client.getApplication())).orElse(null);
        }
        IntrospectionResponseEntity responseEntity = Optional.ofNullable(introspectedToken).map(IntrospectionResponseEntity::new).orElse(new IntrospectionResponseEntity());
        return Response.ok((Object)responseEntity).build();
    }
}

