/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.stream.Collectors;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthToken;
import net.krotscheck.kangaroo.authz.common.database.entity.OAuthTokenType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class IntrospectionResponseEntity {
    private boolean active = false;
    private String scope;
    @JsonProperty(value="client_id")
    private BigInteger clientId;
    private String username;
    @JsonProperty(value="token_type")
    private OAuthTokenType tokenType;
    private Calendar exp;
    private Calendar iat;
    private Calendar nbf;
    private BigInteger sub;
    private BigInteger aud;
    private String iss;
    private BigInteger jti;

    public IntrospectionResponseEntity(OAuthToken token) {
        boolean bl = this.active = token != null && !token.isExpired();
        if (!this.active) {
            return;
        }
        this.tokenType = token.getTokenType();
        this.clientId = token.getClient().getId();
        this.aud = token.getClient().getApplication().getId();
        this.jti = token.getId();
        if (token.getIdentity() != null) {
            this.username = token.getIdentity().getRemoteId();
            this.sub = token.getIdentity().getUser().getId();
        } else {
            this.sub = token.getClient().getId();
        }
        Calendar future = (Calendar)token.getCreatedDate().clone();
        future.add(13, token.getExpiresIn().intValue());
        this.exp = future;
        this.iat = (Calendar)token.getCreatedDate().clone();
        this.nbf = (Calendar)token.getCreatedDate().clone();
        this.scope = token.getScopes().keySet().stream().collect(Collectors.joining(" "));
        this.iss = token.getIssuer();
    }

    public IntrospectionResponseEntity() {
    }

    public boolean isActive() {
        return this.active;
    }

    public String getScope() {
        return this.scope;
    }

    public BigInteger getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public OAuthTokenType getTokenType() {
        return this.tokenType;
    }

    public Calendar getExp() {
        return this.exp;
    }

    public Calendar getIat() {
        return this.iat;
    }

    public Calendar getNbf() {
        return this.nbf;
    }

    public BigInteger getSub() {
        return this.sub;
    }

    public BigInteger getAud() {
        return this.aud;
    }

    public String getIss() {
        return this.iss;
    }

    public BigInteger getJti() {
        return this.jti;
    }
}

