/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import java.util.Arrays;
import java.util.List;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;

public enum GrantType {
    AuthorizationCode("authorization_code"),
    ClientCredentials("client_credentials"),
    Password("password"),
    RefreshToken("refresh_token");

    private static final List<GrantType> ALL;
    private final String value;

    private GrantType(String value) {
        this.value = value;
    }

    public static GrantType fromString(String value) {
        for (GrantType type : ALL) {
            if (!type.value.equals(value)) continue;
            return type;
        }
        throw new RFC6749.InvalidGrantException();
    }

    public String toString() {
        return this.value;
    }

    static {
        ALL = Arrays.asList(AuthorizationCode, ClientCredentials, Password, RefreshToken);
    }
}

