/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.util.SortedMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import net.krotscheck.kangaroo.authz.common.authenticator.AuthenticatorType;
import net.krotscheck.kangaroo.authz.common.database.entity.ApplicationScope;
import net.krotscheck.kangaroo.authz.common.database.entity.Authenticator;
import net.krotscheck.kangaroo.authz.common.database.entity.AuthenticatorState;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.common.util.ValidationUtil;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.authz.oauth2.exception.RedirectingException;
import net.krotscheck.kangaroo.authz.oauth2.resource.authorize.IAuthorizeHandler;
import net.krotscheck.kangaroo.common.exception.KangarooException;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import net.krotscheck.kangaroo.common.hibernate.transaction.Transactional;
import net.krotscheck.kangaroo.util.ObjectUtil;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.hibernate.Session;
import org.jvnet.hk2.annotations.Optional;

@Path(value="/authorize")
@Transactional
@Api(tags={"OAuth2"})
public final class AuthorizationService {
    private final Session session;
    private final SecurityContext securityContext;
    private final InjectionManager injector;

    @Inject
    public AuthorizationService(Session session, SecurityContext securityContext, InjectionManager injector) {
        this.session = session;
        this.securityContext = securityContext;
        this.injector = injector;
    }

    @GET
    @Produces(value={"application/json"})
    @O2Client
    @ApiOperation(value="OAuth2 Authorization endpoint.")
    public Response authorizationRequest(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Optional @QueryParam(value="authenticator") AuthenticatorType authenticator, @Optional @ApiParam(required=true, allowableValues="code,token") @QueryParam(value="response_type") String responseType, @Optional @QueryParam(value="redirect_uri") String redirectUrl, @Optional @ApiParam(example="scope1 scope2") @QueryParam(value="scope") String scope, @Optional @QueryParam(value="state") String state) {
        HttpSession httpSession = request.getSession(true);
        O2Principal principal = (O2Principal)ObjectUtil.safeCast((Object)this.securityContext.getUserPrincipal(), O2Principal.class).orElseThrow(RFC6749.AccessDeniedException::new);
        Client client = principal.getContext();
        URI redirect = ValidationUtil.requireValidRedirect(redirectUrl, client.getRedirects());
        try {
            ValidationUtil.validateResponseType(client, responseType);
            Authenticator auth = ValidationUtil.validateAuthenticator(authenticator, client.getAuthenticators());
            Client c = auth.getClient();
            SortedMap<String, ApplicationScope> scopes = ValidationUtil.validateScope(scope, client.getApplication().getScopes());
            IAuthorizeHandler handler = (IAuthorizeHandler)this.injector.getInstance(IAuthorizeHandler.class, c.getType().toString());
            Response response = handler.handle(httpSession, auth, redirect, scopes, state);
            request.changeSessionId();
            return response;
        }
        catch (KangarooException e) {
            throw new RedirectingException(e, redirect, client.getType());
        }
    }

    @GET
    @Path(value="/callback")
    @Produces(value={"application/json"})
    @ApiOperation(value="3rd Party IdP Callback", hidden=true)
    public Response authorizationCallback(@Context UriInfo uriInfo, @Context HttpServletRequest request, @Optional @DefaultValue(value="") @QueryParam(value="state") String state) {
        HttpSession httpSession = request.getSession(true);
        AuthenticatorState s = this.getAuthenticatorState(state);
        Client c = s.getAuthenticator().getClient();
        try {
            IAuthorizeHandler handler = (IAuthorizeHandler)this.injector.getInstance(IAuthorizeHandler.class, c.getType().toString());
            if (handler == null) {
                throw new RFC6749.InvalidRequestException();
            }
            Response response = handler.callback(s, httpSession);
            request.changeSessionId();
            return response;
        }
        catch (KangarooException e) {
            throw new RedirectingException(e, s.getClientRedirect(), c.getType());
        }
    }

    private AuthenticatorState getAuthenticatorState(String stateString) {
        try {
            BigInteger id = IdUtil.fromString((String)stateString);
            AuthenticatorState callbackState = (AuthenticatorState)((Object)this.session.get(AuthenticatorState.class, (Serializable)id));
            if (callbackState == null) {
                throw new RFC6749.InvalidRequestException();
            }
            return callbackState;
        }
        catch (Exception e) {
            throw new RFC6749.InvalidRequestException();
        }
    }
}

