/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.exception;

import java.net.URI;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ExceptionMapper;
import net.krotscheck.kangaroo.authz.common.database.entity.ClientType;
import net.krotscheck.kangaroo.authz.oauth2.exception.RedirectingException;
import net.krotscheck.kangaroo.common.exception.ErrorResponseBuilder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.spi.ExceptionMappers;

public final class RedirectingExceptionMapper
implements ExceptionMapper<RedirectingException> {
    private final InjectionManager injector;

    @Inject
    RedirectingExceptionMapper(InjectionManager injector) {
        this.injector = injector;
    }

    public Response toResponse(RedirectingException exception) {
        Throwable cause = exception.getCause();
        ExceptionMappers mappers = (ExceptionMappers)this.injector.getInstance(ExceptionMappers.class);
        ExceptionMapper mapper = mappers.findMapping(cause);
        Response r = mapper.toResponse(cause);
        ErrorResponseBuilder.ErrorResponse responseEntity = (ErrorResponseBuilder.ErrorResponse)r.getEntity();
        UriBuilder builder = UriBuilder.fromUri((URI)exception.getRedirect());
        builder.queryParam("error", new Object[]{responseEntity.getError()});
        builder.queryParam("error_description", new Object[]{responseEntity.getErrorDescription()});
        if (exception.getClientType().equals((Object)ClientType.Implicit)) {
            builder.fragment(builder.build(new Object[0]).getQuery());
            builder.replaceQuery("");
        }
        return Response.fromResponse((Response)r).status(Response.Status.FOUND).header("Location", (Object)builder.build(new Object[0])).build();
    }

    public static final class Binder
    extends AbstractBinder {
        protected void configure() {
            ((ClassBinding)((ClassBinding)this.bind(RedirectingExceptionMapper.class).to(RedirectingExceptionMapper.class)).to(ExceptionMapper.class)).in(Singleton.class);
        }
    }
}

