/*
 * Decompiled with CFR 0.152.
 */
package net.krotscheck.kangaroo.authz.oauth2.authn.authn;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.MultivaluedMap;
import net.krotscheck.kangaroo.authz.common.database.entity.Client;
import net.krotscheck.kangaroo.authz.oauth2.authn.O2Principal;
import net.krotscheck.kangaroo.authz.oauth2.authn.authn.AbstractO2AuthenticationFilter;
import net.krotscheck.kangaroo.authz.oauth2.exception.RFC6749;
import net.krotscheck.kangaroo.common.hibernate.id.IdUtil;
import org.glassfish.jersey.server.ContainerRequest;
import org.hibernate.Session;

@Priority(value=1000)
public final class O2ClientQueryParameterFilter
extends AbstractO2AuthenticationFilter {
    public O2ClientQueryParameterFilter(Provider<ContainerRequest> requestProvider, Provider<Session> sessionProvider) {
        super(requestProvider, sessionProvider);
    }

    public void filter(ContainerRequestContext context) {
        String method = context.getMethod();
        if (!method.equals("GET")) {
            return;
        }
        MultivaluedMap queryParameters = context.getUriInfo().getQueryParameters();
        if (queryParameters.containsKey((Object)"client_secret")) {
            throw new BadRequestException();
        }
        if (!queryParameters.containsKey((Object)"client_id")) {
            return;
        }
        List rawClientIds = (List)queryParameters.get((Object)"client_id");
        if (rawClientIds.size() > 1) {
            throw new RFC6749.InvalidClientException();
        }
        try {
            Client client = Optional.of(rawClientIds).map(l -> (String)l.get(0)).map(IdUtil::fromString).map(id -> (Client)((Object)((Object)this.getSession().get(Client.class, (Serializable)id)))).filter(Client::isPublic).orElse(null);
            if (client == null) {
                throw new RFC6749.AccessDeniedException();
            }
            O2Principal principal = new O2Principal(client);
            this.setPrincipal(principal);
        }
        catch (NumberFormatException nfe) {
            throw new BadRequestException();
        }
    }
}

